/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.monitor;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.govern.ExtensionGovernPoJo;
import kd.bos.govern.GovernPoJo;
import kd.bos.govern.StorageReporterRegister;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.allocator.ResourceBalanceController;
import kd.bos.resource.balancer.monitor.metric.MonitorMetricInfo;
import kd.bos.resource.balancer.monitor.metric.ThreadPoolMetricPojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantMonitorReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TenantMonitorReporter.class);
    private ArrayBlockingQueue<ExtensionGovernPoJo> metrics = new ArrayBlockingQueue(10000);
    private final ScheduledExecutorService executor = TenantMonitorReporter.createDefaultExecutor();
    private ScheduledFuture<?> scheduledFuture;
    private static final String REPORTER_THREAD_NAME = "tenantresource-report";
    private static final String SCHEDULED_EXECUTOR_NAME = "tenantresource-scheduled-thread";

    private TenantMonitorReporter() {
    }

    public static TenantMonitorReporter getInstance() {
        return TenantMonitorReporterHolder.INSTANCE;
    }

    private void init() {
        Thread reportThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        ExtensionGovernPoJo poll;
                        if ((poll = this.metrics.poll(9000L, TimeUnit.MILLISECONDS)) == null) {
                            continue;
                        }
                        StorageReporterRegister.esReporter((GovernPoJo)poll);
                    }
                }
                catch (Exception e) {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }, REPORTER_THREAD_NAME);
        reportThread.setDaemon(true);
        reportThread.start();
    }

    public void report() {
        List<MonitorMetricInfo> metricsList = ResourceBalanceController.getMonitorMetricInfo();
        if (metricsList == null || metricsList.isEmpty()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        metricsList.forEach(monitorMetricInfo -> this.metrics.offer(new ThreadPoolMetricPojo(timestamp, (MonitorMetricInfo)monitorMetricInfo)));
    }

    public synchronized void start(long period, TimeUnit unit) {
        if (!Configs.isMetricsReporterEnable() || this.scheduledFuture != null) {
            return;
        }
        this.init();
        this.scheduledFuture = this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.report();
            }
            catch (Throwable ex) {
                LOG.error("Exception thrown from {}#report. Exception was suppressed.", (Object)this.getClass().getSimpleName(), (Object)ex);
            }
        }, period, period, unit);
        LOG.info("TenantMonitorReporter start.");
    }

    public synchronized void stop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
            LOG.warn("TenantMonitorReporter was stop!.");
        }
    }

    private static ScheduledExecutorService createDefaultExecutor() {
        ThreadFactory factory = new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "tenantresource-scheduled-thread-" + this.atomicInteger.incrementAndGet());
            }
        };
        return Executors.newSingleThreadScheduledExecutor(factory);
    }

    private static class TenantMonitorReporterHolder {
        private static final TenantMonitorReporter INSTANCE = new TenantMonitorReporter();

        private TenantMonitorReporterHolder() {
        }
    }
}

