/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.monitor.metric;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.govern.ExtensionGovernPoJo;
import kd.bos.instance.Instance;
import kd.bos.resource.balancer.monitor.metric.MonitorMetricInfo;
import kd.bos.util.NetAddressUtils;

public class ThreadPoolMetricPojo
extends ExtensionGovernPoJo {
    public static final String indexPrefix = Instance.getClusterName() + "-multitenant-";
    private long timestamp;
    private MonitorMetricInfo data;
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private static final String APP_NAME = Instance.getAppName();
    private static final String LOCAL_IP;

    public ThreadPoolMetricPojo(long timestamp, MonitorMetricInfo data) {
        this.timestamp = timestamp;
        this.data = data;
    }

    public String getIndexPrefix() {
        return indexPrefix;
    }

    public Map<String, Object> data2map() {
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        SimpleDateFormat xAxisFormat = new SimpleDateFormat("yyyy-MM-dd\nHH:mm:ss");
        map.put("xAxis", xAxisFormat.format(new Date(this.timestamp)));
        map.put("timestamp", this.timestamp);
        map.put("instanceId", INSTANCE_ID);
        map.put("appName", APP_NAME);
        map.put("ip", LOCAL_IP);
        map.put("accountId", this.data.getAccountId());
        map.put("resourceName", this.data.getResourceName());
        map.put("maxThread", this.data.getMaxThread());
        map.put("quota", this.data.getQuota());
        map.put("maxQueueSize", this.data.getMaxQueueSize());
        map.put("active", this.data.getActive());
        map.put("waiting", this.data.getWaiting());
        map.put("rejected", this.data.getRejected());
        return map;
    }

    static {
        String LOCAL_IP1 = NetAddressUtils.getLocalIpAddress();
        if (NetAddressUtils.isPreferIPv6() && !LOCAL_IP1.startsWith("[")) {
            LOCAL_IP1 = "[" + LOCAL_IP1 + "]";
        }
        LOCAL_IP = LOCAL_IP1;
    }
}

