/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.quota;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.quota.config.ThreadPoolConfig;
import kd.bos.resource.balancer.quota.config.ThreadPoolDef;

public class ResourceConfigManage {
    private static Log log = LogFactory.getLog(ResourceConfigManage.class);
    private static Map<String, ThreadPoolProperties> configs;

    public static void init() {
        ThreadPoolConfig config = ThreadPoolConfig.get();
        if (config == null) {
            return;
        }
        List<ThreadPoolDef> regionList = config.getThreadPools();
        regionList.forEach(v -> {
            ThreadPoolProperties cp = new ThreadPoolProperties();
            cp.name = v.getName();
            cp.maxQueueSize = v.getMaxQueueSize();
            cp.minProportion = v.getMinProportion();
            cp.timeout = v.getTimeout();
            cp.threadName = v.getThreadName();
            configs.put(cp.name, cp);
        });
    }

    public static List<String> getAllResourceList() {
        ArrayList<String> names = new ArrayList<String>(configs.size());
        names.addAll(configs.keySet());
        Collections.sort(names, Comparator.reverseOrder());
        return names;
    }

    public static int getResourceMaxQueueSize(String resourceName) {
        Integer configValue = Configs.getResourceMaxQueueSize(resourceName);
        if (configValue != null) {
            return configValue;
        }
        ThreadPoolProperties p = configs.get(resourceName);
        return p == null ? 100 : p.maxQueueSize;
    }

    public static int getResourceMinProportion(String resourceName) {
        Integer configValue = Configs.getResourceMinProportion(resourceName);
        if (configValue != null) {
            return configValue;
        }
        ThreadPoolProperties p = configs.get(resourceName);
        return p == null ? 5 : p.minProportion;
    }

    public static int getTimeoutThreshold(String resourceName) {
        Integer configValue = Configs.getThreadPoolTimeoutThreshold(resourceName);
        if (configValue != null) {
            return configValue;
        }
        ThreadPoolProperties p = configs.get(resourceName);
        return p == null ? 180 : p.timeout;
    }

    public static String getThreadName(String resourceName) {
        ThreadPoolProperties p = configs.get(resourceName);
        if (p == null || p.threadName == null || p.threadName.trim().length() == 0) {
            return resourceName;
        }
        return p.threadName;
    }

    static {
        try {
            configs = new ConcurrentHashMap<String, ThreadPoolProperties>(6);
            ResourceConfigManage.init();
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    private static class ThreadPoolProperties {
        private String name;
        private int maxQueueSize;
        private int minProportion;
        private int timeout;
        private String threadName;

        private ThreadPoolProperties() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public void setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
        }

        public int getMinProportion() {
            return this.minProportion;
        }

        public void setMinProportion(int minProportion) {
            this.minProportion = minProportion;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }
    }
}

