/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.quota;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.quota.ResourceConfigManage;
import kd.bos.resource.balancer.quota.WeightAndPriority;
import kd.bos.resource.balancer.quota.config.TenantConfigInfo;
import kd.bos.resource.balancer.quota.config.TenantConfigLoader;

public class TenantWeightAndPriority {
    private static Map<String, WeightAndPriority> quotas = new ConcurrentHashMap<String, WeightAndPriority>(2);

    private static String getKey(String resourceName, String accountId) {
        return resourceName + accountId;
    }

    private TenantWeightAndPriority() {
    }

    protected static WeightAndPriority getQuota(String key) {
        return quotas.computeIfAbsent(key, k -> new WeightAndPriority());
    }

    public static WeightAndPriority getQuota(String resourceName, String accountId) {
        String key = TenantWeightAndPriority.getKey(resourceName, accountId);
        WeightAndPriority tenantWeightAndPriority = quotas.get(key);
        if (tenantWeightAndPriority == null) {
            tenantWeightAndPriority = TenantWeightAndPriority.getQuota(resourceName, accountId, true);
        }
        return tenantWeightAndPriority;
    }

    public static synchronized WeightAndPriority getQuota(String resourceName, String accountId, boolean reload) {
        if (!reload) {
            return TenantWeightAndPriority.getQuota(resourceName, accountId);
        }
        String key = TenantWeightAndPriority.getKey(resourceName, accountId);
        WeightAndPriority tenantWeightAndPriority = TenantWeightAndPriority.getQuota(key);
        TenantConfigInfo info = TenantConfigLoader.getTenantConfig(resourceName, accountId);
        tenantWeightAndPriority.setWeight(info.getWeight());
        tenantWeightAndPriority.setMaxQueueSize(info.getMaxQueueSize());
        tenantWeightAndPriority.setMinProportion(info.getMinProportion());
        WeightAndPriority.PriorityLevel priority = WeightAndPriority.PriorityLevel.getPriorityLevel(info.getPriority());
        WeightAndPriority.PriorityLevel priorityLevel = priority == null ? WeightAndPriority.PriorityLevel.FIVE : priority;
        tenantWeightAndPriority.setPriorityLevel(priorityLevel);
        if (tenantWeightAndPriority.getMaxQueueSize() <= 0) {
            tenantWeightAndPriority.setMaxQueueSize(ResourceConfigManage.getResourceMaxQueueSize(resourceName));
        }
        if (tenantWeightAndPriority.getMaxQueueSize() <= 0) {
            tenantWeightAndPriority.setMaxQueueSize(1);
        }
        if (tenantWeightAndPriority.getMinProportion() <= 0) {
            int fromXml = ResourceConfigManage.getResourceMinProportion(resourceName);
            int finalVal = fromXml <= 0 ? 5 : fromXml;
            tenantWeightAndPriority.setMinProportion(finalVal);
        }
        if (accountId == null || "Fixed_Virtual_Tenant_101010".equals(accountId)) {
            tenantWeightAndPriority.setProportion(Configs.getFixedVirtualTenantProportion());
        }
        return tenantWeightAndPriority;
    }
}

