/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.quota;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.quota.ResourceConfigManage;
import kd.bos.resource.balancer.quota.TenantWeightAndPriority;
import kd.bos.resource.balancer.quota.WeightAndPriority;
import kd.bos.tenant.listener.TenantListener;
import kd.bos.tenant.listener.TenantListenerInfo;
import kd.bos.tenant.listener.TenantListenerManager;

public class TenantWeightManage {
    private static Log logger = LogFactory.getLog(TenantWeightManage.class);

    public static void init() {
        TenantListenerManager.addTenantListener((TenantListener)new TenantListener(){

            public void onTenantAccountsRemoved(TenantListenerInfo tenantListenerInfo) {
                TenantWeightManage.reInitWeight();
            }

            public void onTenantAccountsAdded(TenantListenerInfo tenantListenerInfo) {
                TenantWeightManage.reInitWeight();
            }

            public void onTenantChanged(TenantListenerInfo tenantListenerInfo) {
            }
        }, (int)1200);
        TenantWeightManage.reInitWeight();
    }

    public static synchronized void reInitWeight() {
        WeightAndPriority tenantQuota;
        List<String> resourceList = ResourceConfigManage.getAllResourceList();
        HashMap<String, AtomicInteger> totalWeightMap = new HashMap<String, AtomicInteger>(6);
        List<Account> accounts = TenantWeightManage.getAllAccountsOfCurrentEnv();
        for (String resourceName : resourceList) {
            for (Account account : accounts) {
                tenantQuota = TenantWeightManage.getTenantQuota(resourceName, account.getAccountId(), true);
                AtomicInteger t = totalWeightMap.computeIfAbsent(resourceName, k -> new AtomicInteger(0));
                t.getAndAdd(tenantQuota.getWeight());
            }
        }
        for (String resourceName : resourceList) {
            for (Account account : accounts) {
                tenantQuota = TenantWeightManage.getTenantQuota(resourceName, account.getAccountId(), false);
                tenantQuota.setProportion(100 * tenantQuota.getWeight() / ((AtomicInteger)totalWeightMap.get(resourceName)).get());
            }
        }
    }

    public static List<Account> getAllAccountsOfCurrentEnv() {
        try {
            return AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (KDException kdException) {
            logger.error("can not got accounts ", (Throwable)kdException);
            return Collections.emptyList();
        }
    }

    private static WeightAndPriority getTenantQuota(String accountId) {
        return TenantWeightAndPriority.getQuota(accountId);
    }

    private static WeightAndPriority getTenantQuota(String resourceName, String accountId, boolean reload) {
        return TenantWeightAndPriority.getQuota(resourceName, accountId, reload);
    }
}

