/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.quota.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.resource.balancer.quota.ResourceConfigManage;
import kd.bos.resource.balancer.quota.config.TenantConfigDao;
import kd.bos.resource.balancer.quota.config.TenantConfigInfo;

public class DefaultTenantConfigDao
implements TenantConfigDao {
    private static Map<String, TenantConfigInfo> configs = new ConcurrentHashMap<String, TenantConfigInfo>(2);

    @Override
    public TenantConfigInfo getTenantConfig(String resourceName, String accountId) {
        return configs.computeIfAbsent(DefaultTenantConfigDao.getKey(resourceName, accountId), k -> {
            TenantConfigInfo configInfo = new TenantConfigInfo(resourceName, accountId);
            configInfo.setMaxQueueSize(ResourceConfigManage.getResourceMaxQueueSize(resourceName));
            return configInfo;
        });
    }

    private static String getKey(String resourceName, String accountId) {
        return resourceName + accountId;
    }
}

