/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.resource.balancer.quota.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.resource.balancer.Configs;
import kd.bos.resource.balancer.quota.config.ThreadPoolDef;
import kd.bos.util.StringUtils;

@XmlRootElement(name="root")
public class ThreadPoolConfig {
    private static Log log = LogFactory.getLog(ThreadPoolConfig.class);
    private List<ThreadPoolDef> threadPools;

    @XmlElements(value={@XmlElement(name="threadpool", type=ThreadPoolDef.class)})
    public List<ThreadPoolDef> getThreadPools() {
        return this.threadPools;
    }

    public void setThreadPools(List<ThreadPoolDef> threadPools) {
        this.threadPools = threadPools;
    }

    public static ThreadPoolConfig get() {
        String xml = Configs.getThreadPoolConfig();
        if (xml != null && xml.length() > 0) {
            try {
                return ThreadPoolConfig.parse(xml);
            }
            catch (Exception e) {
                log.warn("parse resource balancer thread pool config error from System.getProperty");
            }
        }
        try (InputStream in = ThreadPoolConfig.class.getResourceAsStream("/kd/bos/resource/balancer/KDThreadPoolConfig.xml");){
            xml = StringUtils.fromInputStream((InputStream)in, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("Can't load /kd/bos/resource/balancer/KDThreadPoolConfig.xml, Starting to exit the service\uff1a", (Throwable)e);
            e.printStackTrace();
            LockSupport.parkNanos(1000000000L);
            System.exit(-1);
        }
        if (xml == null) {
            return null;
        }
        return ThreadPoolConfig.parse(xml);
    }

    private static ThreadPoolConfig parse(String xml) {
        return ThreadPoolConfig.parse(new StringReader(xml));
    }

    private static ThreadPoolConfig parse(Reader reader) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ThreadPoolConfig.class});
            XMLInputFactory xif = XMLInputFactory.newFactory();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", true);
            XMLStreamReader xsr = xif.createXMLStreamReader(reader);
            Unmarshaller un = jaxbContext.createUnmarshaller();
            ThreadPoolConfig usageConfig = (ThreadPoolConfig)un.unmarshal(xsr);
            return usageConfig;
        }
        catch (Exception t) {
            throw new KDException(BosErrorCode.resourceThreadPoolConfiguration, "thread pool config parse error,", (Throwable)t);
        }
    }
}

