/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import kd.bos.SessionIdUtils;
import kd.bos.cache.CacheData;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.session.GuestUtiils;
import kd.bos.session.KeysUtils;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class EncreptSessionUtils {
    private static Log logger = LogFactory.getLog(EncreptSessionUtils.class);
    private static final String UTF_8 = "UTF-8";
    public static final String KEY_SESSION_TIMEOUT = "-1";
    private static final String KEY_SESSION_SPLITOR = "~~";
    private static final long KEY_SESSION_DURATON_ATTACHEMENT = 1800000L;
    private static final String KEY_PREFIX_SESSION_ATTACHMENT = "kdedcba";
    public static final String KEY_PREFIX_SESSION_MESSAGE = "kdMessageLogin";
    private static final String ACCOUNT_ID_PARAM = "accountId=";

    public static String encryptSession(String url) {
        String visitorSessionid = StringUtils.randomWord((int)36);
        String value = visitorSessionid + KEY_SESSION_SPLITOR + System.currentTimeMillis();
        Base64.Encoder encoder = Base64.getEncoder();
        try {
            String encodeValue = encoder.encodeToString(value.getBytes(UTF_8));
            StringBuilder addition = new StringBuilder();
            addition.append(url).append(RevProxyUtil.getHttpParamCollectFlag((String)url));
            addition.append(KEY_PREFIX_SESSION_ATTACHMENT).append("=").append(URLEncoder.encode(encodeValue, UTF_8));
            if (StringUtils.isNotEmpty((String)url) && !url.trim().contains(ACCOUNT_ID_PARAM)) {
                addition.append("&").append(ACCOUNT_ID_PARAM).append(RequestContext.get().getAccountId());
            }
            CacheLoginData.setAttribute(KEY_PREFIX_SESSION_ATTACHMENT, visitorSessionid, visitorSessionid, 1800);
            return addition.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Throwable)e);
            return url;
        }
    }

    public static String encryptHttpUrlSession(String url) {
        String visitorSessionid = StringUtils.randomWord((int)36);
        String value = visitorSessionid + KEY_SESSION_SPLITOR + System.currentTimeMillis();
        Base64.Encoder encoder = Base64.getEncoder();
        try {
            String encodeValue = encoder.encodeToString(value.getBytes(UTF_8));
            StringBuilder addition = new StringBuilder();
            addition.append(url).append(RevProxyUtil.getHttpParamCollectFlag((String)url));
            addition.append(KEY_PREFIX_SESSION_ATTACHMENT).append("=").append(URLEncoder.encode(encodeValue, UTF_8));
            if (StringUtils.isNotEmpty((String)url) && !url.trim().contains(ACCOUNT_ID_PARAM)) {
                addition.append("&").append(ACCOUNT_ID_PARAM).append(RequestContext.get().getAccountId());
            }
            CacheLoginData.setAttribute(KEY_PREFIX_SESSION_ATTACHMENT, visitorSessionid, visitorSessionid, 1800);
            return addition.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Throwable)e);
            return url;
        }
    }

    public static String encryptAcessToken(String url, String accessToken) throws UnsupportedEncodingException {
        String value = accessToken + KEY_SESSION_SPLITOR + System.currentTimeMillis();
        Base64.Encoder encoder = Base64.getEncoder();
        String encodeValue = encoder.encodeToString(value.getBytes(UTF_8));
        String flag = "&";
        if (url != null && url.indexOf("?") == -1) {
            flag = "?";
        }
        return url + flag + KEY_PREFIX_SESSION_ATTACHMENT + "=" + URLEncoder.encode(encodeValue, UTF_8);
    }

    public static String decryptSessionId(HttpServletRequest request) {
        String ensession = request.getParameter(KEY_PREFIX_SESSION_ATTACHMENT);
        if (StringUtils.isEmpty((String)ensession)) {
            return null;
        }
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            String desession = new String(decoder.decode(ensession), UTF_8);
            String[] parts = desession.split(KEY_SESSION_SPLITOR);
            long timestamp = Long.parseLong(parts[1]);
            long duration = System.currentTimeMillis() - timestamp;
            if (duration > 1800000L) {
                return KEY_SESSION_TIMEOUT;
            }
            String visitorSessionid = parts[0];
            String guestSessionId = CacheLoginData.getAttribute(KEY_PREFIX_SESSION_ATTACHMENT, visitorSessionid);
            guestSessionId = StringUtils.isNotEmpty((String)guestSessionId) ? EncreptSessionUtils.getGuestSessionId() : visitorSessionid;
            return guestSessionId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encryptMessageLoginSession(String url, long duration) {
        RequestContext rx = RequestContext.get();
        SessionInfo si = new SessionInfo();
        si.setTenantId(rx.getTenantId());
        si.setSandboxId(rx.getSandboxId());
        si.setAccountId(rx.getAccountId());
        si.setOrgId(String.valueOf(rx.getOrgId()));
        si.setUserId(rx.getUserId());
        si.setUserName(rx.getUserName());
        si.setUserOpenId(rx.getUserOpenId());
        si.setUserType(rx.getUserType());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        si.setLoginTime(df.format(new Date()));
        String session = "";
        Base64.Encoder encoder = Base64.getEncoder();
        try {
            String visitorSessionid = SessionManager.copySession(si, Integer.parseInt(String.valueOf(duration)) / 1000);
            String value = visitorSessionid + KEY_SESSION_SPLITOR + System.currentTimeMillis() + KEY_SESSION_SPLITOR + duration;
            String base64Session = encoder.encodeToString(value.getBytes(UTF_8));
            base64Session = base64Session.replaceAll("\r\n", "");
            session = URLEncoder.encode(base64Session, UTF_8);
            logger.debug("\u77ed\u4fe1\u767b\u5f55\u52a0\u5bc6Session\uff1a" + session);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
        return url + "&" + KEY_PREFIX_SESSION_MESSAGE + "=" + session;
    }

    public static String decryptMessageLoginSessionId(HttpServletRequest request) {
        String ensession = request.getParameter(KEY_PREFIX_SESSION_MESSAGE);
        if (StringUtils.isEmpty((String)ensession)) {
            return null;
        }
        try {
            String urlSession = URLDecoder.decode(ensession, UTF_8);
            Base64.Decoder decoder = Base64.getDecoder();
            String desession = new String(decoder.decode(urlSession));
            logger.debug("\u77ed\u4fe1\u767b\u5f55\u89e3\u5bc6Session\uff1a" + desession);
            String[] parts = desession.split(KEY_SESSION_SPLITOR);
            long startTimestamp = Long.parseLong(parts[1]);
            long validDuration = Long.parseLong(parts[2]);
            long duration = System.currentTimeMillis() - startTimestamp;
            if (duration > validDuration) {
                return KEY_SESSION_TIMEOUT;
            }
            return parts[0];
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    private static String encryptTokenLoinSession(String url, long duration) throws UnsupportedEncodingException {
        RequestContext rx = RequestContext.get();
        return KeysUtils.encryptTokenLoinSession(url, rx.getGlobalSessionId(), duration);
    }

    public static String encryptTokenLoinSession(String url) throws UnsupportedEncodingException {
        long duration = 60L;
        return EncreptSessionUtils.encryptTokenLoinSession(url, duration);
    }

    public static String decryptTokenSessionId(HttpServletRequest request) {
        String sessinId = KeysUtils.decryptTokenSessionId(request.getParameter("stoken"));
        if (StringUtils.isNotEmpty((String)sessinId)) {
            CacheData.remove(request.getParameter("stoken"));
        }
        return sessinId;
    }

    public static String generateTicketUrl(String url) throws UnsupportedEncodingException {
        long duration = 60L;
        String returnUrl = url;
        RequestContext rx = RequestContext.get();
        if (rx != null) {
            String ticket = StringUtils.randomWord((int)22);
            CacheData.setAttribute(EncreptSessionUtils.getTicketKey(), ticket, rx.getGlobalSessionId(), (int)duration);
            String flag = "&";
            if (StringUtils.isNotEmpty((String)url) && url.indexOf("?") == -1) {
                flag = "?";
            }
            returnUrl = url + flag + "KDTicket" + "=" + ticket;
        }
        return returnUrl;
    }

    public static String getSessionIDByTicket(String ticket) {
        return CacheData.getAttribute(EncreptSessionUtils.getTicketKey(), ticket);
    }

    private static String getTicketKey() {
        return "sec_ticket";
    }

    public static String getBindingFlag(String sessionId) {
        String bindingFlag = StringUtils.randomWord((int)22);
        CacheData.setAttribute(EncreptSessionUtils.getBingdingKey(), bindingFlag, sessionId, SessionIdUtils.getTimeout(sessionId));
        return bindingFlag;
    }

    public static String getSessionIdByBindingFlag(String bindingFlag) {
        return CacheData.getAttribute(EncreptSessionUtils.getBingdingKey(), bindingFlag);
    }

    public static void refreshBindingFlag(String bindingFlag) {
        String sessionId = EncreptSessionUtils.getSessionIdByBindingFlag(bindingFlag);
        if (StringUtils.isNotEmpty((String)sessionId)) {
            CacheData.setAttribute(EncreptSessionUtils.getBingdingKey(), bindingFlag, sessionId, SessionIdUtils.getTimeout(sessionId));
        }
    }

    public static void removeBindingFlag(String bindingFlag) {
        CacheData.remove(EncreptSessionUtils.getBingdingKey(), bindingFlag);
    }

    private static String getBingdingKey() {
        return "sec_bingding";
    }

    private static String getGuestSessionId() {
        RequestContext context = RequestContext.get();
        String guestSessionId = null;
        if (context == null || StringUtils.isEmpty((String)context.getAccountId())) {
            guestSessionId = GuestUtiils.getGuestUserSessionId();
        } else {
            String accountId = context.getAccountId();
            guestSessionId = CacheLoginData.getAttribute("kdedcbagetGuestSessionId", accountId);
            if (StringUtils.isEmpty((String)guestSessionId)) {
                guestSessionId = GuestUtiils.getGuestUserSessionId();
                CacheLoginData.setAttribute("kdedcbagetGuestSessionId", accountId, guestSessionId, 600);
            }
        }
        return guestSessionId;
    }
}

