/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import kd.bos.session.SystemPropertyUtils;

public class SessionKeys {
    public static final String GLOBAL_COOKIE_SESSION_KEY = "KERPSESSIONID";
    public static final String LOCAL_COOKIE_SESSION_KEY = "JSESSIONID";
    public static final String GLOBAL_COOKIE_ACCESS_TOKEN_KEY = "ACCESS_TOKEN";
    private static final String CSRF_COOKIE_KEY = "KDCSRFKEY";
    private static final String ISOLATORSPAN_COOKIE_KEY = "IsolatorSpan";

    public static String getGlobalCookieSessionkey(String tenantAlias, String accountId) {
        boolean accountSession = SessionKeys.isAccountSession(tenantAlias);
        if (accountSession) {
            return GLOBAL_COOKIE_SESSION_KEY + tenantAlias + accountId;
        }
        return SessionKeys.getGlobalCookieSessionkey(tenantAlias);
    }

    public static String getGlobalCookieAccountIsolatorKey(String tenantAlias) {
        return ISOLATORSPAN_COOKIE_KEY + tenantAlias;
    }

    public static boolean isAccountSession(String tenantAlias) {
        return Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant("svc_login_account_session", tenantAlias));
    }

    public static String getGlobalCookieSessionkey(String tenantAlias) {
        return GLOBAL_COOKIE_SESSION_KEY + tenantAlias;
    }

    public static String getOldGlobalCookieSessionkey() {
        return GLOBAL_COOKIE_SESSION_KEY;
    }

    public static String getCSRFSesssionKey(String tenantAlias) {
        return CSRF_COOKIE_KEY + tenantAlias;
    }
}

