/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.service.SessionDBService;

public class SessionQuery {
    private static final String CLIENT_BATCH = "batch";
    private static RedisSessionableCache cache = new RedisSessionableCache();
    private static String[] ACCOUNTID_USERID_ORGID = new String[]{"accountId", "userId", "orgId"};
    private static String[] ACCOUNTID_USERID = new String[]{"accountId", "userId"};

    public static List<Map<String, String>> getAllSessions(String[] attributes) {
        Set sessionIds = cache.getSessionIds();
        ArrayList<Map<String, String>> sessions = new ArrayList<Map<String, String>>(sessionIds.size());
        for (String sessionId : sessionIds) {
            sessions.add(SessionDAOFactory.getSessionDAO(sessionId).getAttributesAsMap(attributes));
        }
        return sessions;
    }

    public static List<Map<String, String>> getAllSessions(String accountId, String[] attributes) {
        List<SessionInfo> sessionList;
        ArrayList<Map<String, String>> returnList = new ArrayList<Map<String, String>>(50);
        Account account = AccountUtils.getAccountById((String)accountId);
        if (account != null && (sessionList = SessionQuery.getUserSessions(accountId)) != null) {
            for (SessionInfo session : sessionList) {
                returnList.add(session.toMap());
            }
        }
        return returnList;
    }

    public static List<String> getUserSessions(String accountId, String userId) {
        List<String> sessions = new ArrayList<String>();
        Account account = AccountUtils.getAccountById((String)accountId);
        if (account != null) {
            sessions = SessionDBService.getAllSessionsByUserId(account, userId);
        }
        return sessions;
    }

    public static List<SessionInfo> getUserSessions(String accountId) {
        List<SessionInfo> sessions = new ArrayList<SessionInfo>();
        Account account = AccountUtils.getAccountById((String)accountId);
        if (account != null) {
            sessions = SessionDBService.getAllSessions(account);
        }
        return sessions;
    }

    public static List<SessionInfo> getWebUserSessions(String accountId) {
        List<SessionInfo> sessions = new ArrayList<SessionInfo>();
        Account account = AccountUtils.getAccountById((String)accountId);
        if (account != null) {
            sessions = SessionDBService.getAllWEBSessions(account);
        }
        return sessions;
    }
}

