/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import kd.bos.util.StringUtils;

public class SystemPropertyUtils {
    public static Integer getInteger(String tenantId, String key, Integer defaultValue) {
        Integer returnValue = defaultValue;
        String keyValue = SystemPropertyUtils.getProptyByTenant(key, tenantId);
        if (StringUtils.isNotEmpty((String)keyValue) && StringUtils.isNumericString((String)keyValue)) {
            returnValue = Integer.parseInt(keyValue);
        }
        return returnValue;
    }

    @Deprecated
    public static Boolean getBoolean(String tenantId, String key) {
        return SystemPropertyUtils.getBoolean(tenantId, key, Boolean.FALSE);
    }

    @Deprecated
    public static Boolean getBoolean(String tenantId, String key, Boolean defaultValue) {
        Boolean returnValue = defaultValue;
        String keyValue = SystemPropertyUtils.getProptyByTenant(key, tenantId);
        if (StringUtils.isNotEmpty((String)keyValue) && "true".equalsIgnoreCase(keyValue.trim())) {
            returnValue = Boolean.TRUE;
        }
        return returnValue;
    }

    public static Boolean getBooleanExt(String tenantId, String key) {
        return SystemPropertyUtils.getBooleanExt(tenantId, key, Boolean.FALSE);
    }

    public static Boolean getBooleanExt(String tenantId, String key, Boolean defaultValue) {
        Boolean returnValue = defaultValue;
        String keyValue = SystemPropertyUtils.getProptyByTenant(key, tenantId);
        if (StringUtils.isNotEmpty((String)keyValue)) {
            if ("true".equalsIgnoreCase(keyValue.trim())) {
                returnValue = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(keyValue.trim())) {
                returnValue = Boolean.FALSE;
            }
        }
        return returnValue;
    }

    public static String getProptyByTenant(String key, String tenantId) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }
}

