/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.SessionIdUtils;
import kd.bos.cache.database.DistributeSessionCacheWrapper;
import kd.bos.db.SqlParameter;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.metric.Gauge;
import kd.bos.metric.MetricSystem;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.session.impl.ExpireDeamon;
import kd.bos.session.service.SessionDBService;
import org.apache.commons.lang.StringUtils;

public class DistributeCacheSessionDAO
implements SessionDAO {
    private static final Log log = LogFactory.getLog(DistributeCacheSessionDAO.class);
    private static final String config_prefix_key = "metric.session.prefix";
    private static String prefix = "kd.metrics.session.";
    private static Gauge<Integer> sessionGauge = null;
    private static DistributeSessionCacheWrapper cache;
    private static ExpireDeamon expireDeamon;
    private static int expireDeamonPeriod;
    private static ConcurrentHashMap<String, Long> touchTimestampMap;
    private String sessionId;

    public DistributeCacheSessionDAO(String sessionId) {
        this.sessionId = sessionId;
    }

    protected static Integer getCurrentSessionCount() {
        return cache.getSessionCount();
    }

    @Override
    public void touchSession() {
        touchTimestampMap.putIfAbsent(this.sessionId, System.currentTimeMillis());
    }

    private static void touch(String sessionId) {
    }

    private static void initTimeoutDaemon() {
        TimeoutCleaner cleaner = new TimeoutCleaner("Session-Timeout-Daemon", 60, 120000);
        cleaner.start();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getAttribute(String key) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        return cache.get(this.sessionId, key);
    }

    @Override
    public String[] getAttributes(String[] keys) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        List<String> atts = cache.get(this.sessionId, keys);
        if (atts == null) {
            return null;
        }
        return atts.toArray(new String[atts.size()]);
    }

    @Override
    public Map<String, String> getAttributesAsMap(String[] keys) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        List<String> atts = cache.get(this.sessionId, keys);
        if (atts == null || atts.size() == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(atts.size());
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], atts.get(i));
        }
        return result;
    }

    @Override
    public void setAttribute(String key, String value) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        cache.put(this.sessionId, key, value);
    }

    @Override
    public void setAttributes(Map<String, String> map) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        cache.put(this.sessionId, map);
    }

    @Override
    public void remove() {
        cache.remove(this.sessionId);
    }

    @Override
    public void expireAfter(int second) {
        cache.expireAfter(this.sessionId, second);
    }

    @Override
    public void removeByKeyPrefix(String keyPrefix) {
        List<String> keys = cache.getKeysWithPrefix(this.sessionId, keyPrefix);
        if (keys != null && !keys.isEmpty()) {
            cache.remove(this.sessionId, keys.toArray(new String[keys.size()]));
        }
        DistributeCacheSessionDAO.touch(this.sessionId);
    }

    @Override
    public void initSessionId(String accountId) {
        cache.addSessionId(this.sessionId, accountId);
    }

    @Override
    public void updateExpireTimeout() {
    }

    static {
        expireDeamonPeriod = 5000;
        touchTimestampMap = new ConcurrentHashMap();
        cache = new DistributeSessionCacheWrapper();
        expireDeamon = new ExpireDeamon(cache, expireDeamonPeriod);
        String enable = System.getProperty("metrics.enable.sessionCount");
        if ("true".equals(enable)) {
            String p = System.getProperty(config_prefix_key, prefix);
            String name = p + "activeCount";
            sessionGauge = new Gauge<Integer>(){

                public Integer getValue() {
                    return DistributeCacheSessionDAO.getCurrentSessionCount();
                }
            };
            MetricSystem.registerGauge((String)name, sessionGauge);
        }
        DistributeCacheSessionDAO.initTimeoutDaemon();
    }

    static class TimeoutCleaner
    extends Thread {
        private int timeout;
        private int loopInterval;

        TimeoutCleaner(String name, int timeout, int loopInterval) {
            super(name);
            this.timeout = timeout;
            this.loopInterval = loopInterval;
        }

        private int toSecond(long ms) {
            return (int)(ms / 1000L);
        }

        @Override
        public void run() {
            while (true) {
                ArrayList keys = null;
                for (Map.Entry entry : touchTimestampMap.entrySet()) {
                    long time = (Long)entry.getValue();
                    if (this.toSecond(System.currentTimeMillis() - time) <= this.getFreshTimeOut()) continue;
                    if (keys == null) {
                        keys = new ArrayList();
                    }
                    keys.add(entry.getKey());
                }
                if (keys != null) {
                    HashMap<String, List<Object[]>> accountList = new HashMap<String, List<Object[]>>();
                    for (String key : keys) {
                        try {
                            int timeout = SessionIdUtils.getTimeout(key);
                            boolean isAPI = false;
                            if (SessionIdUtils.isAPI(key)) {
                                timeout = SessionIdUtils.getAPITimeout(key);
                                isAPI = true;
                            }
                            int ttl = timeout - this.toSecond(System.currentTimeMillis() - (Long)touchTimestampMap.get(key));
                            SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(key);
                            if (sessionDAO != null) {
                                sessionDAO.setAttribute("expiredTime", String.valueOf(DateUtils.plusSecondsWithDate(new Date(), ttl).getTime()));
                            }
                            cache.expireAfter(key, ttl);
                            String accountId = SessionIdUtils.getAccountIdFromKey(key);
                            ArrayList<SqlParameter[]> paramList = (ArrayList<SqlParameter[]>)accountList.get(accountId);
                            if (paramList == null) {
                                paramList = new ArrayList<SqlParameter[]>();
                            }
                            paramList.add(SessionDBService.getSqlParameter(key, DateUtils.plusSecondsWithDate(new Date(), timeout)));
                            accountList.put(accountId, paramList);
                            SessionManager.expireCacheValue(key, ttl * 2);
                            touchTimestampMap.remove(key);
                        }
                        catch (Exception t) {
                            log.warn((Throwable)t);
                        }
                    }
                    this.refreshSessions(accountList);
                }
                try {
                    Thread.sleep(this.getLoopInterval());
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn((Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void refreshSessions(Map<String, List<Object[]>> accountList) {
            if (accountList != null) {
                for (Map.Entry<String, List<Object[]>> entry : accountList.entrySet()) {
                    String accountId = entry.getKey();
                    List<Object[]> list = entry.getValue();
                    if (this.getFreshNeedBatch()) {
                        this.stepFresh(accountId, list);
                        continue;
                    }
                    this.refreshSessionList(accountId, list);
                }
            }
        }

        private void refreshSessionList(String accountId, List<Object[]> list) {
            try {
                SessionManager.refreshBatchSession(AccountUtils.getAccountById((String)accountId), list);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
            }
        }

        private void stepFresh(String accountId, List<Object[]> list) {
            int step = this.getFreshStepInterval();
            int i = 1;
            boolean isOk = true;
            while (isOk) {
                List<Object[]> needList = null;
                if (i * step < list.size()) {
                    needList = this.copyList(list, (i - 1) * step, step);
                } else {
                    needList = this.copyList(list, (i - 1) * step, list.size() - (i - 1) * step);
                    isOk = false;
                }
                this.refreshSessionList(accountId, needList);
                if (this.getFreshNeedSleep()) {
                    try {
                        Thread.sleep(this.getFreshSleepInterval());
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e);
                    }
                }
                ++i;
            }
        }

        private List<Object[]> copyList(List<Object[]> src, int start, int end) {
            ArrayList<Object[]> reutrnList = new ArrayList<Object[]>();
            if (src != null && src.size() >= start + end) {
                for (int i = 0; i < end; ++i) {
                    reutrnList.add(src.get(start + i));
                }
            }
            return reutrnList;
        }

        private int getFreshTimeOut() {
            return SystemPropertyUtils.getInteger("", "session_timeout", this.timeout);
        }

        private int getLoopInterval() {
            return SystemPropertyUtils.getInteger("", "session_loop_refresh_interval", this.loopInterval);
        }

        private boolean getFreshNeedBatch() {
            return this.getBooleanProperty("session_refresh_need_batch", "", true);
        }

        private boolean getBooleanProperty(String properKey, String tenantId, boolean defaultValue) {
            boolean returnValue = defaultValue;
            String batchString = SystemPropertyUtils.getProptyByTenant(properKey, "");
            if (StringUtils.isNotEmpty((String)batchString) && !"true".equalsIgnoreCase(batchString.trim())) {
                returnValue = false;
            } else if (StringUtils.isNotEmpty((String)batchString) && "true".equalsIgnoreCase(batchString.trim())) {
                returnValue = true;
            }
            return returnValue;
        }

        private boolean getFreshNeedSleep() {
            return this.getBooleanProperty("session_refresh_need_sleep", "", true);
        }

        private int getFreshSleepInterval() {
            return SystemPropertyUtils.getInteger("", "session_loop_refresh_sleep_interval", 500);
        }

        private int getFreshStepInterval() {
            return SystemPropertyUtils.getInteger("", "session_loop_refresh_step_interval", 500);
        }
    }
}

