/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.SessionIdUtils;
import kd.bos.cache.DistributeSessionableCache;

public class ExpireDeamon {
    private DistributeSessionableCache cache;
    private ConcurrentHashMap<String, Long> map = new ConcurrentHashMap();

    public ExpireDeamon(DistributeSessionableCache cache, int period) {
        this.cache = cache;
        Timer timer = new Timer("SessionExpireDeamon", true);
        timer.schedule(this.createTimeTask(), 0L, (long)period);
    }

    private TimerTask createTimeTask() {
        return new TimerTask(){

            @Override
            public void run() {
                ExpireDeamon.this.runOnce();
            }
        };
    }

    protected void runOnce() {
        if (this.map.isEmpty()) {
            return;
        }
        HashMap<String, Long> todo = new HashMap<String, Long>();
        todo.putAll(this.map);
        this.map.clear();
        for (Map.Entry entry : todo.entrySet()) {
            this._expire((String)entry.getKey(), (Long)entry.getValue());
        }
    }

    public void expireNow(String sessionId) {
        this.map.put(sessionId, System.currentTimeMillis());
    }

    private void _expire(String sessionId, long timestamp) {
        int delta = (int)(System.currentTimeMillis() - timestamp) / 1000;
        int timeout = SessionIdUtils.getTimeout(sessionId);
        int seconds = timeout - delta;
        this.cache.expireAfter(sessionId, seconds);
    }
}

