/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session.service;

import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class DBUtils {
    private static ErrorCode ERROR_CODE = new ErrorCode("", "");
    private static Log logger = LogFactory.getLog(DBUtils.class);

    private DBUtils() {
        throw new IllegalStateException("DBUtils class");
    }

    public static boolean execute(Account account, DBRoute dbRoute, String sql, Object[] params) {
        boolean isSucceed = false;
        if (account != null) {
            RequestContextInfo rcInfo = new RequestContextInfo(account.getTenantId(), account.getAccountId());
            try (AutoCloseable ac = rcInfo.setupThreadRequestContext();
                 TXHandle handle = TX.requiresNew();){
                isSucceed = DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDException(ERROR_CODE, new Object[]{e.getMessage()});
            }
        }
        return isSucceed;
    }

    public static boolean executeBatch(Account account, DBRoute dbRoute, String sql, List<Object[]> params) {
        boolean isSucceed = false;
        if (account != null) {
            RequestContextInfo rcInfo = new RequestContextInfo(account.getTenantId(), account.getAccountId());
            try (AutoCloseable ac = rcInfo.setupThreadRequestContext();
                 TXHandle handle = TX.requiresNew();){
                DB.executeBatch((DBRoute)DBRoute.basedata, (String)sql, params);
                isSucceed = true;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDException(ERROR_CODE, new Object[]{e.getMessage()});
            }
        }
        return isSucceed;
    }

    /*
     * Exception decompiling
     */
    public static <T> T query(Account account, DBRoute dbRoute, String sql, Object[] params, ResultSetHandler<T> rsh) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static <T> T query(DBRoute dbRoute, String sql, Object[] params, ResultSetHandler<T> rsh) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getColumn(String column) {
        if (StringUtils.isNotEmpty((String)column)) {
            return "f" + column;
        }
        return column;
    }

    public static String getNonNullString(String param) {
        if (param == null) {
            return "";
        }
        return param;
    }
}

