/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.share;

import java.io.IOException;
import java.time.Instant;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.share.ShareInfo;
import kd.bos.url.UrlService;
import kd.bos.util.JSONUtils;
import org.apache.commons.lang.StringUtils;

public class ShareUrlService {
    private static Log logger = LogFactory.getLog(ShareUrlService.class);
    private static final String SHARE_URL = "shareUrl";
    private static final String KDSHARE = "kdshare";

    public static String createShareUrl(String formId, String pkId, int validTime, String userId, String langName, String accountId) {
        ShareInfo shareInfo = new ShareInfo();
        shareInfo.setFormId(formId);
        shareInfo.setPkId(pkId);
        shareInfo.setShareUserId(userId);
        shareInfo.setShareTime(Instant.now().toEpochMilli());
        shareInfo.setValidTime(validTime);
        shareInfo.setLangName(langName);
        shareInfo.setAccountId(accountId);
        String uuid = kd.bos.util.StringUtils.randomWord((int)36);
        String key = ShareUrlService.getKey(uuid);
        try {
            CacheLoginData.setAttribute(SHARE_URL, key, JSONUtils.toString((Object)shareInfo), validTime);
        }
        catch (IOException e) {
            logger.error("ShareUrlService--setCache error" + e);
        }
        String domainUrl = UrlService.getDomainContextUrl();
        if (StringUtils.isNotBlank((String)domainUrl) && !domainUrl.endsWith("/")) {
            domainUrl = domainUrl + "/";
        }
        return domainUrl + KDSHARE + ".do?formId=" + formId + "&shareId=" + uuid;
    }

    public static ShareInfo getShareInfo(String uuid) {
        String data = CacheLoginData.getAttribute(SHARE_URL, ShareUrlService.getKey(uuid));
        if (StringUtils.isNotEmpty((String)data)) {
            try {
                return (ShareInfo)JSONUtils.cast((String)data, ShareInfo.class);
            }
            catch (IOException e) {
                logger.error("ShareUrlService--getCache cast error", (Throwable)e);
            }
        }
        return null;
    }

    private static String getKey(String uuid) {
        return "kdshare-" + uuid;
    }
}

