/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.threads;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.api.Probe;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.DynamicExecutorService;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.WaitingRejectedHandler;
import kd.bos.threads.impl.DynamicExecutorServiceImpl;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.threads.impl.ThreadPoolImpl;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class ThreadPools {
    private static Map<String, ThreadPool> poolMap = new ConcurrentHashMap<String, ThreadPool>();
    private static Map<String, ExecutorService> esPoolMap = new ConcurrentHashMap<String, ExecutorService>();
    private static Map<String, DynamicExecutorService> dynamicPoolMap = new ConcurrentHashMap<String, DynamicExecutorService>();
    private static final Integer MAX_FIX_QUEUESIZE = Integer.getInteger("threadpool.fix.maxqueue.size", 100000);
    private static final Integer MAX_CACHED_THREADSIZE = Integer.getInteger("threadpool.cached.maxthread.size", 10000);
    private static final Integer MAX_CUSTOM_QUEUESIZE = Integer.getInteger("threadpool.custom.maxqueue.size", 100000);

    public static void executeOnce(String name, Runnable runnable) {
        ThreadPools.executeOnceIncludeRequestContext(name, runnable);
    }

    public static void executeOnce(String name, Runnable runnable, String appId) {
        ThreadPools.executeOnceIncludeRequestContext(name, runnable, appId);
    }

    public static void executeOnce(String name, Runnable runnable, OperationContext oc) {
        ThreadPools.executeOnceIncludeRequestContext(name, runnable, oc);
    }

    public static void executeOnceIncludeRequestContext(String name, Runnable runnable) {
        ThreadPools.executeOnceIncludeRequestContext(name, runnable, RequestContextCreator.createForThreadPool(), null);
    }

    public static void executeOnceIncludeRequestContext(String name, Runnable runnable, String appId) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        ThreadPools.executeOnceIncludeRequestContext(name, runnable, RequestContextCreator.createForThreadPool(), oc);
    }

    public static void executeOnceIncludeRequestContext(String name, Runnable runnable, OperationContext operationContext) {
        ThreadPools.executeOnceIncludeRequestContext(name, runnable, RequestContextCreator.createForThreadPool(), operationContext);
    }

    private static void executeOnceIncludeRequestContext(String name, Runnable runnable, RequestContext rc, OperationContext operationContext) {
        runnable = new RequestContextRunnable(runnable, rc, operationContext);
        runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
        new Thread(runnable, name).start();
    }

    public static ExecutorService newExecutorService(String poolName, int nThreads) {
        if (poolName == null) {
            throw new RuntimeException("poolName_1 can`t be null");
        }
        ExecutorService pool = esPoolMap.get(poolName);
        if (pool == null) {
            pool = ThreadPools.createFixedThreadPool(poolName, nThreads);
            esPoolMap.put(poolName, pool);
            return pool;
        }
        throw new RuntimeException("thread pool of " + poolName + " has been created ,please choose another pool name .");
    }

    @SdkInternal
    public static synchronized ThreadPool getOrCreateFixedThreadPool(String poolName, int nThreads) {
        return ThreadPools.newFixedThreadPool(poolName, nThreads);
    }

    public static ThreadPool newFixedThreadPool(String poolName, int nThreads) {
        return ThreadPools.newFixedThreadPool(poolName, nThreads, (OperationContext)null);
    }

    public static ThreadPool newFixedThreadPool(String poolName, int nThreads, String appId) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        return ThreadPools.newFixedThreadPool(poolName, nThreads, oc);
    }

    public static ThreadPool newFixedThreadPool(String poolName, int nThreads, OperationContext oc) {
        ThreadPool pool = poolMap.get(poolName);
        if (pool == null) {
            Consumer<Boolean> consumer = v -> ThreadPools.removeFromMap(poolName);
            pool = new ThreadPoolImpl(ThreadPools.createFixedThreadPool(poolName, nThreads), oc, consumer);
            poolMap.put(poolName, pool);
            return pool;
        }
        throw new RuntimeException("thread pool of " + poolName + " has been created ,please choose another pool name .");
    }

    private static Boolean removeFromMap(String poolName) {
        poolMap.remove(poolName);
        return true;
    }

    private static ExecutorService createFixedThreadPool(final String poolName, int nThreads) {
        if (nThreads > 1000) {
            nThreads = 1000;
        }
        Probe.touch((String)"threadpool");
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(MAX_FIX_QUEUESIZE), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
            }
        }, new WaitingRejectedHandler()));
    }

    public static ThreadPool newCachedThreadPool(String poolName) {
        return ThreadPools.newCachedThreadPool(poolName, 0, 1000);
    }

    public static ThreadPool newCachedThreadPool(String poolName, String appId) {
        return ThreadPools.newCachedThreadPool(poolName, 0, 1000, appId);
    }

    public static ThreadPool newCachedThreadPool(String poolName, int coreThread, int maxThread) {
        return ThreadPools.newCachedThreadPool(poolName, coreThread, maxThread, (OperationContext)null);
    }

    public static ThreadPool newCachedThreadPool(String poolName, int coreThread, int maxThread, String appId) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        return ThreadPools.newCachedThreadPool(poolName, coreThread, maxThread, oc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPool newCachedThreadPool(String poolName, int coreThread, int maxThread, OperationContext operationContext) {
        if (maxThread <= 0 || maxThread > MAX_CACHED_THREADSIZE) {
            maxThread = MAX_CACHED_THREADSIZE;
        }
        if (coreThread < 0 || coreThread > 30) {
            coreThread = 3;
        }
        if (poolName == null) {
            throw new RuntimeException("poolName_2 can`t be null");
        }
        ThreadPool pool = poolMap.get(poolName);
        if (pool == null) {
            Map<String, ThreadPool> map = poolMap;
            synchronized (map) {
                pool = poolMap.get(poolName);
                if (pool == null) {
                    Consumer<Boolean> consumer = v -> ThreadPools.removeFromMap(poolName);
                    pool = new ThreadPoolImpl(ThreadPools.createCachedExecutorService(poolName, coreThread, maxThread), operationContext, consumer);
                    poolMap.put(poolName, pool);
                    return pool;
                }
            }
        }
        throw new RuntimeException("Thread pool of " + poolName + " has been created ,please choose another pool name.");
    }

    public static ExecutorService newCachedExecutorService(String poolName) {
        return ThreadPools.newCachedExecutorService(poolName, 0, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService newCachedExecutorService(String poolName, int coreThread, int maxThread) {
        if (maxThread <= 0 || maxThread > 10000) {
            maxThread = 1000;
        }
        if (coreThread <= 0 || coreThread > 30) {
            coreThread = 3;
        }
        if (poolName == null) {
            throw new RuntimeException("poolName_3 can`t be null");
        }
        ExecutorService pool = esPoolMap.get(poolName);
        if (pool == null) {
            Map<String, ExecutorService> map = esPoolMap;
            synchronized (map) {
                pool = esPoolMap.get(poolName);
                if (pool == null) {
                    pool = ThreadPools.createCachedExecutorService(poolName, coreThread, maxThread);
                    esPoolMap.put(poolName, pool);
                    return pool;
                }
            }
        }
        throw new RuntimeException("Thread pool of " + poolName + " has been created ,please choose another pool name.");
    }

    private static ExecutorService createCachedExecutorService(final String poolName, int coreThread, int maxThread) {
        Probe.touch((String)"threadpool");
        return ThreadLifeCycleManager.wrapExecutorService((ExecutorService)new ThreadPoolExecutor(coreThread, maxThread, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, poolName + "-" + this.atomicInteger.incrementAndGet());
            }
        }, new WaitingRejectedHandler()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicExecutorService newDynamicExecutorService(String poolName, int coreThread, int maxThread) {
        if (maxThread <= 0 || maxThread > 10000) {
            maxThread = 1000;
        }
        if (coreThread <= 0 || coreThread > 30) {
            coreThread = 3;
        }
        if (poolName == null) {
            throw new RuntimeException("poolName_4 can`t be null");
        }
        DynamicExecutorService pool = dynamicPoolMap.get(poolName);
        if (pool == null) {
            Map<String, DynamicExecutorService> map = dynamicPoolMap;
            synchronized (map) {
                pool = dynamicPoolMap.get(poolName);
                if (pool == null) {
                    pool = new DynamicExecutorServiceImpl(ThreadPools.createCachedExecutorService(poolName, coreThread, maxThread));
                    dynamicPoolMap.put(poolName, pool);
                    return pool;
                }
            }
        }
        throw new RuntimeException("Thread pool of " + poolName + " has been created ,please choose another pool name.");
    }

    public static ThreadPool toThreadPool(ExecutorService es, String appId) {
        OperationContext oc = new OperationContext();
        oc.setAppId(appId);
        return ThreadPools.toThreadPool(es, oc);
    }

    public static ThreadPool toThreadPool(ExecutorService es, OperationContext oc) {
        return new ThreadPoolImpl(es, oc, null);
    }
}

