/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.threads.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.DynamicExecutorService;

public class DynamicExecutorServiceImpl
implements DynamicExecutorService {
    private final ExecutorService es;

    public DynamicExecutorServiceImpl(ExecutorService es) {
        this.es = es;
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            if (corePoolSize > executor.getMaximumPoolSize()) {
                executor.setMaximumPoolSize(corePoolSize);
            }
            executor.setCorePoolSize(corePoolSize);
        }
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            if (maximumPoolSize < executor.getCorePoolSize()) {
                executor.setCorePoolSize(maximumPoolSize);
            }
            executor.setMaximumPoolSize(maximumPoolSize);
        }
    }

    @Override
    public int getCorePoolSize() {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            return executor.getCorePoolSize();
        }
        return -1;
    }

    @Override
    public int getMaximumPoolSize() {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            return executor.getMaximumPoolSize();
        }
        return -1;
    }

    @Override
    public int getActiveCount() {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            return executor.getActiveCount();
        }
        return -1;
    }

    @Override
    public int getPoolSize() {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            return executor.getPoolSize();
        }
        return -1;
    }

    @Override
    public int getLargestPoolSize() {
        ExecutorService original = ThreadLifeCycleManager.getOriginalExecutorService((ExecutorService)this.es);
        if (original instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)original;
            return executor.getLargestPoolSize();
        }
        return -1;
    }

    @Override
    public void shutdown() {
        this.es.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.es.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.es.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.es.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.es.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.es.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.es.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.es.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.es.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.es.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.es.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.es.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.es.execute(command);
    }
}

