/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.XDBErrorCode;
import kd.bos.util.StringUtils;
import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.cache.RollbackableCache;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.ext.ExtContext;

public class AutoCloseSet {
    private static final AtomicInteger parallelSeq = new AtomicInteger();
    private final int parallelId;
    private final ParallelConnectionHolder connectionHolder;
    private final Object lock = new Object();
    private String dbRoute;
    private List<Connection> conList = new ArrayList<Connection>();
    private Set<Statement> stmtMap = new HashSet<Statement>();

    public AutoCloseSet() {
        this.parallelId = parallelSeq.getAndIncrement();
        this.connectionHolder = ConnectionProvider.get().getConnectionHolder();
    }

    public int parallelId() {
        return this.parallelId;
    }

    public void add(Connection con) {
        this.add(ExtContext.get().getDBRoute(), con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String curRoute, Connection con) {
        Object object = this.lock;
        synchronized (object) {
            if (StringUtils.isNotEmpty((String)this.dbRoute) && !curRoute.equalsIgnoreCase(this.dbRoute)) {
                StringBuilder msg = new StringBuilder(1024);
                msg.append("Can not write more than one database: ").append(this.dbRoute).append(" has written,").append(curRoute).append(" can not write.");
                throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
            }
            this.dbRoute = curRoute;
            this.conList.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Statement stmt) {
        Object object = this.lock;
        synchronized (object) {
            this.stmtMap.add(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean rollback) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            Cache cc;
            if (rollback && (cc = CacheContext.get().getCurrentCache()) instanceof RollbackableCache) {
                ((RollbackableCache)((Object)cc)).setRollbacked(true);
            }
            try {
                for (Statement stmt : this.stmtMap) {
                    if (stmt.isClosed()) continue;
                    stmt.close();
                }
                this.stmtMap.clear();
            }
            catch (Throwable throwable) {
                for (Connection con : this.conList) {
                    this.connectionHolder.closeConnection(this.dbRoute, con, rollback);
                }
                this.conList.clear();
                throw throwable;
            }
            for (Connection con : this.conList) {
                this.connectionHolder.closeConnection(this.dbRoute, con, rollback);
            }
            this.conList.clear();
        }
    }

    public void clear() {
        this.stmtMap.clear();
        this.conList.clear();
    }
}

