/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.xdb.sharding.sql.SQLInfo;

public class ParallelTag {
    private final int roundCount;
    private final AtomicInteger completedCount;
    private final String tag;
    private boolean asSerialExecution = false;
    private SQLInfo sqlInfo;

    public ParallelTag(long parallelId, int round, int roundCount, AtomicInteger completedCount) {
        this.roundCount = roundCount;
        this.completedCount = completedCount;
        this.tag = "P" + parallelId + '#' + roundCount + '-' + round;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String completeAndGetPercent() {
        AtomicInteger atomicInteger = this.completedCount;
        synchronized (atomicInteger) {
            int c = this.completedCount.incrementAndGet() * 100 / this.roundCount;
            return c + "%";
        }
    }

    public void tagSerialExcution() {
        this.asSerialExecution = true;
    }

    public SQLInfo getSqlInfo() {
        return this.sqlInfo;
    }

    public void setSqlInfo(SQLInfo sqlInfo) {
        this.sqlInfo = sqlInfo;
    }

    public String toString() {
        if (this.asSerialExecution) {
            return this.tag + " serial execution ";
        }
        return this.tag;
    }
}

