/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.cache.global.ShardingSQLCache;
import kd.bos.xdb.cache.global.ShardingSQLCacheFactory;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.dlock.DLock;
import kd.bos.xdb.dlock.DLockImpl;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.ext.KSQLTransfer;
import kd.bos.xdb.id.IDGenner;
import kd.bos.xdb.id.IDUtil;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.tablemanager.DefaultTableManagerFactory;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableManagerFactory;

public class XDBConfig {
    private static final XDBConfig instance = new XDBConfig();
    private static TableManagerFactory tmf = new DefaultTableManagerFactory();
    private static Supplier<XDBExternal> xdbExternalSupplier;
    private static Supplier<Boolean> xdbEnableSupplier;
    private static Supplier<Boolean> mergeStableEnableSupplier;
    private static Supplier<Integer> webRequestTimeoutSupplier;
    private static boolean paramWithKSQLTimePattern;
    private static boolean paramUseOpenGaussFiller;
    private static int exceedShardingtableQueryLimit;
    private static boolean distinctTransGroupby;
    private static int mergeStableParallelSize;
    private static int mergeStreamParallelSize;
    private static int mergePerSegSize;
    private static int mergePerStoreSize;
    private static boolean mergeSegParallelExecute;
    private static boolean parseSkip;
    private static Set<String> ignoreNotifyCacheNumbers;
    private static boolean indexStandardLimit;
    private int queryTimeoutSeconds = 300;
    private int queryFetchSize = 1000;
    private int singleParallelSize = Integer.parseInt(System.getProperty("xdb.single.parallel_query_size", String.valueOf(3)));
    private int globalParallelSize = Integer.parseInt(System.getProperty("xdb.global.parallel_query_size", String.valueOf(12)));
    private boolean enableParallelExecute = true;
    private boolean forceParallelConn = false;
    private boolean ignoreUnsupportedStatement = true;
    private boolean useKSQL = false;
    private int fetchSize = -1;
    private KSQLTransfer KSqlTransfer;
    private boolean devMode = false;
    private boolean pkSeg = false;
    private int modMax = 10000;
    private boolean enableSharding = false;
    private boolean shardingSameGroupTable = true;
    private boolean enableLogShardingSQL = true;
    private boolean enableLogNoShardingSQL = true;
    private boolean enableLogStat = true;
    private boolean spaceAsEmptyString = false;
    private boolean mixSharding = Boolean.parseBoolean(System.getProperty("xdb.mixSharding", "true"));
    private int cacheDefaultSize = Integer.parseInt(System.getProperty("xdb.cache.default.size", String.valueOf(10240)));
    private int cacheShardingFieldValueSize = Integer.parseInt(System.getProperty("xdb.cache.shardingfieldvalue.size", String.valueOf(10240)));
    private int cachePKSize = Integer.parseInt(System.getProperty("xdb.cache.pk.size", String.valueOf(10240)));
    private int cacheSqlMaxLength = Integer.parseInt(System.getProperty("xdb.cache.sql.maxLength", String.valueOf(0x100000)));
    private int cacheSqlSize = Integer.parseInt(System.getProperty("xdb.cache.sql.size", String.valueOf(10240)));
    private int queryIndexBatchSize = Integer.parseInt(System.getProperty("xdb.query.index.batchsize", String.valueOf(2000)));
    private int updateIndexBatchSize = Integer.parseInt(System.getProperty("xdb.update.index.batchsize", String.valueOf(500)));

    public static XDBConfig get() {
        return instance;
    }

    public static void setup(TableManagerFactory tmf, ShardingSQLCacheFactory ssf, ShardingConfigProvider scp, ConnectionProvider dsp, Supplier<XDBExternal> xdbExternalSupplier) {
        if (tmf != null) {
            XDBConfig.tmf = tmf;
        }
        if (xdbExternalSupplier != null) {
            XDBConfig.xdbExternalSupplier = xdbExternalSupplier;
        }
        ShardingEngineFactory.setup(ssf, scp);
        if (dsp != null) {
            ConnectionProvider.set(dsp);
        }
    }

    public static void setupDLock(DLock dlock) {
        DLockImpl.setupDLock(dlock);
    }

    public static void setupIDGenner(IDGenner genner) {
        IDUtil.setIDGenner(genner);
    }

    public static void setupGovernTimeout(Supplier<Integer> webRequestTimeoutSupplier) {
        XDBConfig.webRequestTimeoutSupplier = webRequestTimeoutSupplier;
    }

    public static void setupXDBEnable(Supplier<Boolean> xdbEnableSupplier) {
        XDBConfig.xdbEnableSupplier = xdbEnableSupplier;
    }

    public static Supplier<Boolean> getXDBEnableSupplier() {
        return xdbEnableSupplier;
    }

    public static Supplier<Boolean> getMergeStableEnableSupplier() {
        return mergeStableEnableSupplier;
    }

    public static void setMergeStableEnableSupplier(Supplier<Boolean> mergeStableEnableSupplier) {
        XDBConfig.mergeStableEnableSupplier = mergeStableEnableSupplier;
    }

    public static TableManager getTableManager() {
        return tmf.getTableManager();
    }

    public static ShardingSQLCache getShardingSQLCache() {
        return ShardingEngineFactory.getShardingSQLCache();
    }

    public static ShardingConfigProvider getShardingConfigProvider() {
        return ShardingEngineFactory.getShardingConfigProvider();
    }

    public static ConnectionProvider getConnectionProvider() throws Exception {
        return ConnectionProvider.get();
    }

    static Supplier<XDBExternal> getXDBExternalSupplier() {
        return xdbExternalSupplier;
    }

    public static boolean isXDBEnabled() {
        return xdbEnableSupplier != null && xdbEnableSupplier.get() != false;
    }

    public static int handleWebRequestTimeout() {
        return webRequestTimeoutSupplier != null ? webRequestTimeoutSupplier.get() : Integer.MAX_VALUE;
    }

    public int getQueryTimeoutSeconds() {
        return this.queryTimeoutSeconds;
    }

    public void setQueryTimeoutSeconds(int queryTimeoutSeconds) {
        this.queryTimeoutSeconds = queryTimeoutSeconds;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public boolean isEnableParallelExecute() {
        return this.enableParallelExecute;
    }

    public void setEnableParallelExecute(boolean enableParallelExecute) {
        this.enableParallelExecute = enableParallelExecute;
    }

    public boolean isForceParallelConn() {
        return this.forceParallelConn;
    }

    public void setForceParallelConn(boolean forceParallelConn) {
        this.forceParallelConn = forceParallelConn;
    }

    public KSQLTransfer getKSqlTransfer() {
        return this.KSqlTransfer;
    }

    public void setKSqlTransfer(KSQLTransfer KSqlTransfer) {
        this.KSqlTransfer = KSqlTransfer;
    }

    public boolean isUseKSQL() {
        return this.useKSQL;
    }

    public void setUseKSQL(boolean useKSQL) {
        this.useKSQL = useKSQL;
    }

    @Deprecated
    public boolean isEnableLogOriginalSQL() {
        return false;
    }

    @Deprecated
    public void setEnableLogOriginalSQL(boolean enableLogOriginalSQL) {
    }

    public boolean isEnableLogShardingSQL() {
        return this.enableLogShardingSQL;
    }

    public void setEnableLogShardingSQL(boolean enableLogShardingSQL) {
        this.enableLogShardingSQL = enableLogShardingSQL;
    }

    public boolean isEnableLogNoShardingSQL() {
        return this.enableLogNoShardingSQL;
    }

    public void setEnableLogNoShardingSQL(boolean enableLogNoShardingSQL) {
        this.enableLogNoShardingSQL = enableLogNoShardingSQL;
    }

    public boolean isIgnoreUnsupportedStatement() {
        return this.ignoreUnsupportedStatement;
    }

    public void setIgnoreUnsupportedStatement(boolean ignoreUnsupportedStatement) {
        this.ignoreUnsupportedStatement = ignoreUnsupportedStatement;
    }

    public boolean isEnableSharding() {
        return this.enableSharding;
    }

    public void setEnableSharding(boolean enableSharding) {
        this.enableSharding = enableSharding;
    }

    public boolean isEnableLogStat() {
        return this.enableLogStat;
    }

    public void setEnableLogStat(boolean enableLogStat) {
        this.enableLogStat = enableLogStat;
    }

    public int getSingleParallelSize() {
        return this.singleParallelSize;
    }

    public void setSingleParallelSize(int singleParallelSize) {
        this.singleParallelSize = singleParallelSize;
    }

    public int getExceedShardingtableQueryLimit() {
        return exceedShardingtableQueryLimit;
    }

    public void setExceedShardingtableQueryLimit(int exceedShardingtableQueryLimit) {
        XDBConfig.exceedShardingtableQueryLimit = exceedShardingtableQueryLimit;
    }

    public int getGlobalParallelSize() {
        return this.globalParallelSize;
    }

    public void setGlobalParallelSize(int globalParallelSize) {
        this.globalParallelSize = globalParallelSize;
    }

    public static boolean isMergeStableEnable() {
        return mergeStableEnableSupplier != null && mergeStableEnableSupplier.get() != false;
    }

    public static int getMergeStableParallelSize() {
        return mergeStableParallelSize;
    }

    public static int getMergeStreamParallelSize() {
        return mergeStreamParallelSize;
    }

    public static int getMergePerSegSize() {
        return mergePerSegSize;
    }

    public static int getMergePerStoreSize() {
        return mergePerStoreSize;
    }

    public static boolean isMergeSegParallelExecute() {
        return mergeSegParallelExecute;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isSpaceAsEmptyString() {
        return this.spaceAsEmptyString;
    }

    public void setSpaceAsEmptyString(boolean spaceAsEmptyString) {
        this.spaceAsEmptyString = spaceAsEmptyString;
    }

    public boolean isDevMode() {
        return this.devMode;
    }

    public void setDevMode(boolean devMode) {
        this.devMode = devMode;
    }

    public int getModMax() {
        return this.modMax;
    }

    public void setModMax(int modMax) {
        this.modMax = modMax;
    }

    public boolean isPkSeg() {
        return this.pkSeg;
    }

    public void setPkSeg(boolean pkSeg) {
        this.pkSeg = pkSeg;
    }

    public int getCacheSqlMaxLength() {
        return this.cacheSqlMaxLength;
    }

    public int getCacheSqlSize() {
        return this.cacheSqlSize;
    }

    public int getCacheDefaultSize() {
        return this.cacheDefaultSize;
    }

    public int getCachePKSize() {
        return this.cachePKSize;
    }

    public int getCacheShardingFieldValueSize() {
        return this.cacheShardingFieldValueSize;
    }

    public boolean isShardingSameGroupTable() {
        return this.shardingSameGroupTable;
    }

    public void setShardingSameGroupTable(boolean shardingSameGroupTable) {
        this.shardingSameGroupTable = shardingSameGroupTable;
    }

    public boolean isMixSharding() {
        return this.mixSharding;
    }

    public void setMixSharding(boolean mixSharding) {
        this.mixSharding = mixSharding;
    }

    public static boolean isParamWithKSQLTimePattern() {
        return paramWithKSQLTimePattern;
    }

    public static boolean isDistinctTransGroupby() {
        return distinctTransGroupby;
    }

    public static boolean paramUseOpenGaussFiller() {
        return paramUseOpenGaussFiller;
    }

    public int getQueryIndexBatchSize() {
        return this.queryIndexBatchSize;
    }

    public int getUpdateIndexBatchSize() {
        return this.updateIndexBatchSize;
    }

    public boolean isParseSkip() {
        return parseSkip;
    }

    public void setParseSkip(boolean parseSkip) {
        XDBConfig.parseSkip = parseSkip;
    }

    public static boolean isIndexStandardLimit() {
        return indexStandardLimit;
    }

    public static boolean isNotifyCacheNumberIgnore(String entityNumber) {
        return ignoreNotifyCacheNumbers.isEmpty() || ignoreNotifyCacheNumbers.contains(entityNumber);
    }

    static {
        paramWithKSQLTimePattern = false;
        paramUseOpenGaussFiller = true;
        exceedShardingtableQueryLimit = 12;
        distinctTransGroupby = false;
        mergeStableParallelSize = 3;
        mergeStreamParallelSize = 10;
        mergePerSegSize = 3;
        mergePerStoreSize = 10;
        mergeSegParallelExecute = true;
        parseSkip = true;
        ignoreNotifyCacheNumbers = new HashSet<String>();
        indexStandardLimit = true;
        ConfigurationUtil.observeBoolean((String)"xdb.param.withKSQLTimePattern", (boolean)false, v -> {
            paramWithKSQLTimePattern = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.exceed.shardingtable.query.limit", (int)12, v -> {
            exceedShardingtableQueryLimit = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.distinct.trans.groupby", (boolean)false, v -> {
            distinctTransGroupby = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.merge.stable.enable", (boolean)true, v -> XDBConfig.setMergeStableEnableSupplier(() -> v));
        ConfigurationUtil.observeInteger((String)"xdb.merge.stable.parallel.size", (int)3, v -> {
            mergeStableParallelSize = v > 1 ? v : 2;
        });
        ConfigurationUtil.observeInteger((String)"xdb.merge.stream.parallel.size", (int)10, v -> {
            mergeStreamParallelSize = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.merge.per.seg.size", (int)3, v -> {
            mergePerSegSize = v > 1 ? v : 2;
        });
        ConfigurationUtil.observeInteger((String)"xdb.merge.per.store.size", (int)10, v -> {
            mergePerStoreSize = v > 1 ? v : 2;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.merge.parallel.execute", (boolean)true, v -> {
            mergeSegParallelExecute = v;
        });
        ConfigurationUtil.observeBoolean((String)"xdb.parse.skip.enable", (boolean)true, v -> {
            parseSkip = v;
        });
        ConfigurationUtil.observeString((String)"xdb.notify.cache.ignore.numbers", (String)"", v -> {
            if (v != null && v.length() > 0) {
                ignoreNotifyCacheNumbers = new HashSet<String>(Arrays.asList(v.split(",")));
            }
        });
        ConfigurationUtil.observeBoolean((String)"xdb.index.standard.limit", (boolean)false, v -> {
            indexStandardLimit = v;
        });
    }
}

