/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.log.SqlLogger;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.util.ArrayUtil;

public class XDBLog
implements XDBLogable {
    private static SqlLogger sqlLogger;
    public static boolean enableShardingOutSQL;
    public static boolean logWithParameter;
    private static final DateTimeFormatter dateTimeFormatter;

    public static void setSqlLogger(SqlLogger sqlLogger) {
        XDBLog.sqlLogger = sqlLogger;
    }

    public static void logSharding(SQLInfo ss, boolean forManager) {
        XDBLog.logSharding(ss, forManager, null);
    }

    public static void logSharding(SQLInfo ss, boolean forManager, String appendMessage) {
        XDBLog.logSharding(ss, forManager, appendMessage, 0L);
    }

    public static void logSharding(SQLInfo ss, boolean forManager, String appendMessage, long ms) {
        if (enableShardingOutSQL) {
            boolean managerSQL = forManager;
            if (!(ss.isShardingSQL() || forManager || XDBConfig.get().isEnableLogNoShardingSQL())) {
                return;
            }
            if (sqlLogger != null || log.isInfoEnabled()) {
                Object[] params;
                String prefix;
                if (ss.isShardingSQL()) {
                    prefix = "[Sharding-SQL]\n";
                    ShardingHintContext ctx = ss.getShardingHintContext();
                    if (ctx != null) {
                        prefix = prefix + ctx.toString() + '\n';
                    }
                    if (!StringUtils.isEmpty((String)ss.getDbRoute())) {
                        prefix = prefix + ss.getDbRoute() + '\n';
                    }
                } else {
                    prefix = managerSQL ? "[Sharding-Manager-SQL]\n" : "[NoSharding-SQL]\n";
                }
                StringBuilder sb = new StringBuilder(1024).append(prefix).append(ss.getSql());
                if (logWithParameter && (params = ss.getParams()) != null && params.length > 0) {
                    sb.append('\n');
                    sb.append(ArrayUtil.toParameterString(params));
                }
                if (appendMessage != null) {
                    sb.append('\n').append(appendMessage);
                }
                sb.append('\n');
                if (ms > 0L) {
                    sb.append("#cost:").append(ms).append("ms,time is:").append(dateTimeFormatter.format(LocalDateTime.now())).append(",");
                }
                if (sqlLogger != null) {
                    sqlLogger.logMessage(sb.toString());
                } else {
                    log.info(sb.toString());
                }
            }
        }
    }

    static {
        enableShardingOutSQL = false;
        logWithParameter = false;
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
        ConfigurationUtil.observeBoolean((String)"xdb.log.sharding", (boolean)enableShardingOutSQL, v -> {
            enableShardingOutSQL = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.sql.out.withParameter", (boolean)logWithParameter, v -> {
            logWithParameter = v;
        });
    }
}

