/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.cache.global;

import com.alibaba.druid.sql.ast.SQLStatement;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.util.LRUCacheMap;

public final class ShardingSQLCache {
    private static final SQLStatement EMPTY_STMT = (SQLStatement)Proxy.newProxyInstance(SQLStatement.class.getClassLoader(), new Class[]{SQLStatement.class}, (a, b, c) -> {
        throw new UnsupportedOperationException("Can't invoke an empty SQLStatement");
    });
    private static int cache_sql_max_length = XDBConfig.get().getCacheSqlMaxLength();
    private Map<String, SQLStatement> cache = Collections.synchronizedMap(new LRUCacheMap(XDBConfig.get().getCacheSqlSize()));

    public void addNonSharding(String dbRoute, String sql) {
        if (sql.length() <= cache_sql_max_length) {
            this.addSharding(dbRoute, sql, EMPTY_STMT);
        }
    }

    public void addSharding(String dbRoute, String sql, SQLStatement stmt) {
        if (sql.length() <= cache_sql_max_length) {
            String key = dbRoute + "#" + sql;
            this.cache.put(key, stmt);
        }
    }

    public SQLStatement get(String dbRoute, String sql) {
        if (sql.length() <= cache_sql_max_length) {
            String key = dbRoute + "#" + sql;
            return this.cache.get(key);
        }
        return null;
    }

    public boolean isNonSharding(SQLStatement stmt) {
        return stmt == EMPTY_STMT;
    }

    public void clear() {
        this.cache.clear();
    }
}

