/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.context;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.context.ShardingListener;
import kd.bos.xdb.context.XDBContext;
import kd.bos.xdb.engine.ShardingResult;

public final class XDBContextImpl
implements XDBContext {
    private static final ThreadLocal<XDBContextImpl> th = ThreadLocals.create();
    private XDBContextImpl parent = th.get();
    private List<ShardingListener> slList;

    static XDBContextImpl create() {
        return new XDBContextImpl();
    }

    public static XDBContextImpl get() {
        return th.get();
    }

    private XDBContextImpl() {
        th.set(this);
    }

    @Override
    public void close() {
        if (this.parent != null) {
            th.set(this.parent);
        } else {
            th.remove();
        }
    }

    @Override
    public void addShardingListener(ShardingListener sl) {
        if (this.slList == null) {
            this.slList = new ArrayList<ShardingListener>();
        }
        this.slList.add(sl);
    }

    public void fireOnSharding(ShardingResult ... srs) {
        if (this.slList != null) {
            for (ShardingListener sl : this.slList) {
                sl.onSharding(srs);
            }
        }
        if (this.parent != null) {
            this.parent.fireOnSharding(srs);
        }
    }
}

