/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.util.StringUtils;
import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.exception.ExceptionUtil;

public abstract class AbstractParallelConnectionHolder
implements ParallelConnectionHolder {
    private Object lock = new Object();
    private Connection mainCon;
    private AtomicReference<Thread> busyMainCon = new AtomicReference();
    private LinkedList<Connection> freeQueryConList = new LinkedList();
    private LinkedList<Connection> busyQueryConList = new LinkedList();
    private Map<Connection, AtomicInteger> queryConRefMap = new HashMap<Connection, AtomicInteger>();
    private Map<String, LinkedList<Connection>> routeFreeConListMap = new ConcurrentHashMap<String, LinkedList<Connection>>();
    private Map<String, LinkedList<Connection>> routeBusyConListMap = new ConcurrentHashMap<String, LinkedList<Connection>>();
    private Map<String, AtomicReference<Thread>> routeBusyMainConMap = new ConcurrentHashMap<String, AtomicReference<Thread>>();
    protected Map<String, Connection> archiveConMap = new ConcurrentHashMap<String, Connection>();
    protected String archiveRouteKey;

    public AbstractParallelConnectionHolder() throws SQLException {
        this.mainCon = this.createConnection(true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection requireConnection(boolean forManager, boolean forQuery, boolean inTx, String dbRoute, String curRoute, String querySQL) throws SQLException {
        Object con;
        Object xdbe;
        boolean isUseTheSameDatabase = dbRoute.equalsIgnoreCase(curRoute);
        if (!isUseTheSameDatabase) {
            xdbe = XDBExternal.requiresNew("xdb.requireConnection");
            Throwable throwable = null;
            try {
                isUseTheSameDatabase = ((XDBExternal)xdbe).isUseTheSameDatabase(dbRoute, curRoute);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (xdbe != null) {
                    if (throwable != null) {
                        try {
                            ((XDBExternal)xdbe).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((XDBExternal)xdbe).close();
                    }
                }
            }
        }
        if (isUseTheSameDatabase) {
            if (forManager || inTx) {
                return this.waitForMainConnection(curRoute, forQuery);
            }
            if (!XDBConfig.get().isForceParallelConn()) {
                xdbe = this.busyMainCon;
                synchronized (xdbe) {
                    Thread currentThread = Thread.currentThread();
                    Thread thread = this.busyMainCon.get();
                    if (thread == null) {
                        this.busyMainCon.set(currentThread);
                        return this.mainCon;
                    }
                    if (thread == currentThread) {
                        return this.mainCon;
                    }
                }
            }
            xdbe = this.lock;
            synchronized (xdbe) {
                if (!this.freeQueryConList.isEmpty()) {
                    con = this.freeQueryConList.poll();
                    this.busyQueryConList.add((Connection)con);
                    this.queryConRefMap.get(con).incrementAndGet();
                    return con;
                }
                con = this.createConnection(false, querySQL);
                if (con != this.mainCon) {
                    this.busyQueryConList.add((Connection)con);
                    this.queryConRefMap.put((Connection)con, new AtomicInteger(1));
                    return con;
                }
            }
            return this.waitForMainConnection(curRoute, forQuery);
        }
        if (inTx) {
            return this.waitForRouteMainConnection(curRoute, forQuery);
        }
        if (this.getArchiveCon(curRoute) != null && !XDBConfig.get().isForceParallelConn()) {
            AtomicReference routeBusyMainCon = this.routeBusyMainConMap.computeIfAbsent(curRoute, key -> new AtomicReference());
            con = routeBusyMainCon;
            synchronized (con) {
                Thread currentThread = Thread.currentThread();
                Thread thread = (Thread)routeBusyMainCon.get();
                if (thread == null) {
                    routeBusyMainCon.set(currentThread);
                    return this.getArchiveCon(curRoute);
                }
                if (thread == currentThread) {
                    return this.getArchiveCon(curRoute);
                }
            }
        }
        Object object = this.lock;
        synchronized (object) {
            Connection con2;
            LinkedList curFreeRouteConList = this.routeFreeConListMap.computeIfAbsent(curRoute, key -> new LinkedList());
            if (!curFreeRouteConList.isEmpty()) {
                con2 = (Connection)curFreeRouteConList.poll();
                this.routeBusyConListMap.get(curRoute).add(con2);
                this.queryConRefMap.get(con2).incrementAndGet();
                return con2;
            }
            con2 = this.createArchiveConnection(false, false, curRoute);
            LinkedList curBusyRouteConList = this.routeBusyConListMap.computeIfAbsent(curRoute, key -> new LinkedList());
            curBusyRouteConList.add(con2);
            this.queryConRefMap.put(con2, new AtomicInteger(1));
            return con2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection waitForMainConnection(String dbRoute, boolean forQuery) {
        if (!forQuery) {
            this.checkMultiDBRouteWrited(true, dbRoute);
        }
        Thread currentThread = Thread.currentThread();
        AtomicReference<Thread> atomicReference = this.busyMainCon;
        synchronized (atomicReference) {
            try {
                Thread thread = this.busyMainCon.get();
                while (thread != null && thread != currentThread) {
                    this.busyMainCon.wait();
                    thread = this.busyMainCon.get();
                }
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.wrap(e);
            }
            this.busyMainCon.set(currentThread);
            if (!forQuery) {
                this.mainHappened();
            }
            return this.mainCon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection waitForRouteMainConnection(String dbRoute, boolean forQuery) throws SQLException {
        AtomicReference routeBusyMainCon;
        if (!forQuery) {
            this.checkMultiDBRouteWrited(false, dbRoute);
        }
        Thread currentThread = Thread.currentThread();
        AtomicReference atomicReference = routeBusyMainCon = this.routeBusyMainConMap.computeIfAbsent(dbRoute, key -> new AtomicReference());
        synchronized (atomicReference) {
            try {
                Thread thread = (Thread)routeBusyMainCon.get();
                while (thread != null && thread != currentThread) {
                    routeBusyMainCon.wait();
                    thread = (Thread)routeBusyMainCon.get();
                }
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.wrap(e);
            }
            routeBusyMainCon.set(currentThread);
            return this.createArchiveConnection(true, !forQuery, dbRoute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseForSharing(String dbRoute, Connection con) {
        if (con == this.mainCon) {
            AtomicReference<Thread> atomicReference = this.busyMainCon;
            synchronized (atomicReference) {
                this.busyMainCon.set(null);
                this.busyMainCon.notifyAll();
            }
        }
        if (con == this.getArchiveCon(dbRoute)) {
            AtomicReference<Thread> routeBusyMainCon;
            AtomicReference<Thread> atomicReference = routeBusyMainCon = this.routeBusyMainConMap.get(dbRoute);
            synchronized (atomicReference) {
                routeBusyMainCon.set(null);
                routeBusyMainCon.notifyAll();
            }
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.routeBusyConListMap.get(dbRoute) != null) {
                this.routeBusyConListMap.get(dbRoute).remove(con);
                this.routeFreeConListMap.get(dbRoute).add(con);
            } else {
                this.busyQueryConList.remove(con);
                this.freeQueryConList.add(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnection(String dbRoute, Connection con, boolean rollback) throws SQLException {
        boolean main = con == this.mainCon || con == this.getArchiveCon(dbRoute);
        try {
            if (rollback) {
                this.rollbackConnection(main, con);
            }
        }
        finally {
            if (main) {
                if (con == this.mainCon) {
                    AtomicReference<Thread> atomicReference = this.busyMainCon;
                    synchronized (atomicReference) {
                        this.busyMainCon.set(null);
                        this.busyMainCon.notifyAll();
                    }
                } else {
                    AtomicReference<Thread> routeBusyMainCon;
                    AtomicReference<Thread> atomicReference = routeBusyMainCon = this.routeBusyMainConMap.get(dbRoute);
                    synchronized (atomicReference) {
                        routeBusyMainCon.set(null);
                        routeBusyMainCon.notifyAll();
                    }
                }
            } else {
                Object object = this.lock;
                synchronized (object) {
                    if (this.queryConRefMap.get(con).decrementAndGet() == 0) {
                        if (StringUtils.isNotEmpty((String)dbRoute) && this.routeFreeConListMap.get(dbRoute) != null) {
                            this.routeFreeConListMap.get(dbRoute).remove(con);
                        } else {
                            this.freeQueryConList.remove(con);
                        }
                        this.closeConnection(false, con);
                    }
                }
            }
        }
    }

    @Override
    public boolean isMainConnection(Connection con) {
        return con == this.mainCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldingConnections() {
        Object object = this.lock;
        synchronized (object) {
            return this.freeQueryConList.size() + this.busyQueryConList.size() + 1;
        }
    }

    protected abstract Connection createConnection(boolean var1, String var2) throws SQLException;

    protected abstract Connection createArchiveConnection(boolean var1, boolean var2, String var3) throws SQLException;

    protected abstract void closeConnection(boolean var1, Connection var2) throws SQLException;

    protected abstract void rollbackConnection(boolean var1, Connection var2) throws SQLException;

    protected abstract String getArchiveRouteKey();

    protected abstract Map<String, Connection> getArchiveConMap();

    protected abstract Connection getArchiveCon(String var1);

    protected abstract boolean isMainHappened();

    protected abstract void mainHappened();

    protected abstract void checkMultiDBRouteWrited(boolean var1, String var2);
}

