/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.engine;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.KSQLIfExistsStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlCreateTableStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.cache.global.DefaultShardingSQLCacheFactory;
import kd.bos.xdb.cache.global.ShardingSQLCache;
import kd.bos.xdb.cache.global.ShardingSQLCacheFactory;
import kd.bos.xdb.context.XDBContextImpl;
import kd.bos.xdb.engine.BatchShardingContext;
import kd.bos.xdb.engine.ShardingEngine;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.engine.StatementShardingEngine;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.ExtractHeadCommentAndTrim;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.DefaultShardingConfigProvider;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.indexpk.BatchInsertIndexPKAction;
import kd.bos.xdb.sharding.indexpk.IndexPKStore;
import kd.bos.xdb.sharding.indexpk.QueryIndexPKAction;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.ddl.DDLShardingSQL;
import kd.bos.xdb.sharding.sql.dml.DeleteShardingSQL;
import kd.bos.xdb.sharding.sql.dml.IfExistsShardingSQL;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.ExtractParameterPosition;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.ConditionVisitor;
import kd.bos.xdb.sharding.sql.visitor.ResolvePropertyOwnerVisitor;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.children.ChildrenStrategy;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.metrics.action.sharding.ShardingEmptySpan;
import kd.bos.xdb.xpm.metrics.action.sharding.ShardingTableSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

class ShardingEngineImpl
implements ShardingEngine,
StatementShardingEngine,
XDBLogable {
    private static final XDBConfig config = XDBConfig.get();
    private ShardingSQLCacheFactory ssf = new DefaultShardingSQLCacheFactory();
    private ShardingConfigProvider scp = new DefaultShardingConfigProvider();

    ShardingEngineImpl() {
    }

    void setup(ShardingSQLCacheFactory ssf, ShardingConfigProvider scp) {
        if (ssf != null) {
            this.ssf = ssf;
        }
        if (scp != null) {
            this.scp = scp;
        }
    }

    @Override
    public ShardingResult sharding(String sql, Object[] params) {
        MetricsCollector mc = MetricsCollector.getCurrent();
        mc.sqlFeature().setSql(sql);
        ShardingResult sr = this.sharding(null, sql, params, this.ssf.getShardingSQLCache(), null, mc);
        if (mc.sqlFeature().isSharding() && mc.isPerformanceMetricEnabled()) {
            mc.performanceMetric().setShardingSQLCount(sr.getSQLInfos().length);
        }
        if (sr.getSQLInfos().length > 0 && sr.getSQLInfos()[0].isShardingSQL()) {
            XDBContextImpl ctx;
            if (sr.getStatementInfo().getStatementType() != StatementType.select) {
                BatchInsertIndexPKAction.commitActionIfPresent();
            }
            if ((ctx = XDBContextImpl.get()) != null) {
                ctx.fireOnSharding(sr);
            }
        }
        return sr;
    }

    private boolean batchLoadShardingTableByPK(StatementInfo stmtInfo, List<Object[]> paramsList, ShardingResult[] srs) {
        if (stmtInfo.getStatementType() != StatementType.update) {
            return false;
        }
        SQLUpdateStatement stmt = (SQLUpdateStatement)stmtInfo.getSQLStatement();
        String updateTable = stmt.getTableName().toString();
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(updateTable);
        int N = paramsList.size();
        if (config instanceof MainTableConfig && stmtInfo.getTableInfos().size() == 1) {
            SQLExpr conditionExp = stmt.getWhere();
            ConditionVisitor cv = new ConditionVisitor();
            conditionExp.accept((SQLASTVisitor)cv);
            List<ConditionInfo> cis = cv.getConditionInfos();
            if (cis.size() == 1) {
                String pkField = ((AbstractShardingStrategy)config.getShardingStrategy()).getPKField();
                String field = cis.get(0).getField();
                boolean isEffective = false;
                if (pkField.equals(field)) {
                    field = "fpk";
                    isEffective = true;
                } else if (config.getOptions().getIndexNameSet().contains(field)) {
                    isEffective = true;
                }
                FilterType filterType = cis.get(0).getFilterType();
                if (filterType == FilterType.eq && isEffective) {
                    ArrayList<Object> pks = new ArrayList<Object>(paramsList.size());
                    int seg = paramsList.get(0).length - 1;
                    for (int i = 0; i < N; ++i) {
                        pks.add(paramsList.get(i)[seg]);
                    }
                    Map<Object, Set<Long>> pkIndexMap = QueryIndexPKAction._queryShardingIndexWithoutCache(updateTable, field, pks);
                    for (int i = 1; i < N; ++i) {
                        Object pk = paramsList.get(i)[seg];
                        Long[] pkIndexs = new Long[]{Long.parseLong("-1")};
                        if (null != pkIndexMap.get(pk)) {
                            Set<Long> pkIndexSet = pkIndexMap.get(pk);
                            pkIndexs = pkIndexSet.toArray(new Long[pkIndexSet.size()]);
                        }
                        srs[i] = srs[0].shareShardingResult(paramsList.get(i), pkIndexs);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShardingResult[] batchSharding(String sql, List<Object[]> paramsList) {
        MetricsCollector mc = MetricsCollector.getCurrent();
        mc.sqlFeature().setSql(sql);
        int N = paramsList.size();
        if (N == 0) {
            return new ShardingResult[0];
        }
        ExtractHeadCommentAndTrim ec = new ExtractHeadCommentAndTrim(mc);
        ec.extract(sql);
        sql = ec.getSql();
        ExtractParameterPosition ep = new ExtractParameterPosition();
        ShardingSQLCache sqlStmtCache = this.ssf.getShardingSQLCache();
        ShardingResult sr = this.sharding(ec, sql, paramsList.get(0), sqlStmtCache, ep, mc);
        if (sr.getSQLInfos()[0].isShardingSQL()) {
            try {
                XDBContextImpl ctx;
                boolean shareBatchSharding;
                ShardingResult[] srs = new ShardingResult[N];
                srs[0] = sr;
                ShardingHintContext hintCtx = ec.getShardingHintContext();
                if (hintCtx == null) {
                    hintCtx = ShardingHintContext.get();
                }
                boolean batchLoad = hintCtx == null && sr.getSQLInfos()[0].getParams().length == paramsList.get(0).length && !mc.sqlFeature().isWithUpdateIndexField() && !mc.sqlFeature().isWithUpdateShardingField() && this.batchLoadShardingTableByPK(sr.getStatementInfo(), paramsList, srs);
                boolean allowBatch = !batchLoad && (sr.getSQLInfos().length == 1 || sr.getStatementInfo().getStatementType() != StatementType.insert);
                boolean bl = shareBatchSharding = allowBatch && hintCtx != null && !hintCtx.isSkipHint() && hintCtx.isBatchShardingEnabled() && !mc.sqlFeature().isWithUpdateIndexField() && !mc.sqlFeature().isWithUpdateShardingField();
                if (shareBatchSharding) {
                    SQLInfo si0 = sr.getSQLInfos()[0];
                    Object[] params0 = si0.getParams();
                    if (!(paramsList instanceof ArrayList) || ep.hasExtract()) {
                        paramsList = new ArrayList<Object[]>(paramsList);
                    }
                    if (ep.hasExtract()) {
                        ep.sameExtract(params0, paramsList, 1);
                    }
                    for (int i = 1; i < N; ++i) {
                        srs[i] = sr.shareShardingResult(paramsList.get(i));
                    }
                } else if (!batchLoad) {
                    Iterator<Object[]> iter = paramsList.iterator();
                    iter.next();
                    try (BatchShardingContext bctx = BatchShardingContext.create();){
                        for (int i = 1; i < N; ++i) {
                            srs[i] = this.sharding(ec, sql, iter.next(), sqlStmtCache, null, mc);
                        }
                    }
                }
                if (mc.isPerformanceMetricEnabled()) {
                    mc.performanceMetric().setShardingSQLCount(sr.getSQLInfos().length);
                }
                if ((ctx = XDBContextImpl.get()) != null) {
                    ctx.fireOnSharding(srs);
                }
                ShardingResult[] shardingResultArray = srs;
                return shardingResultArray;
            }
            finally {
                if (sr.getStatementInfo().getStatementType() != StatementType.select) {
                    BatchInsertIndexPKAction.commitActionIfPresent();
                }
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private ShardingResult sharding(ExtractHeadCommentAndTrim ec, String sql, Object[] params, ShardingSQLCache sqlStmtCache, ExtractParameterPosition ep, MetricsCollector mc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isOrderByMiss(String orderByName, List<SQLSelectItem> selectItems) {
        for (SQLSelectItem item : selectItems) {
            String selectName = item.getExpr().toString().toLowerCase();
            if (selectName.equals(orderByName)) {
                return false;
            }
            if (null == item.getAlias() || !item.getAlias().toLowerCase().equals(orderByName)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllFieldsCanTransform(List<SQLSelectItem> selectItems) {
        for (SQLSelectItem item : selectItems) {
            if (item.getExpr() instanceof SQLIdentifierExpr || item.getExpr() instanceof SQLPropertyExpr) continue;
            return false;
        }
        return true;
    }

    private boolean isOrderByExist(SQLOrderBy orderBy, SQLSelectItem item) {
        if (orderBy == null) {
            return false;
        }
        for (SQLSelectOrderByItem orderByItem : orderBy.getItems()) {
            String orderByName = orderByItem.getExpr().toString().toLowerCase();
            String selectName = item.getExpr().toString().toLowerCase();
            if (selectName.equals(orderByName)) {
                return true;
            }
            if (null == item.getAlias() || !item.getAlias().toLowerCase().equals(orderByName)) continue;
            return true;
        }
        return false;
    }

    private boolean isGroupByAndOrderByItemsSame(SelectFeature sf) {
        HashMap<String, Integer> aliasMap = new HashMap<String, Integer>(16);
        HashMap<String, Integer> exprNameMap = new HashMap<String, Integer>(16);
        int k = 0;
        List<SQLSelectItem> selectItems = sf.getSelectItems();
        for (SQLSelectItem selectItem : selectItems) {
            String exprName = selectItem.getExpr().toString();
            exprNameMap.put(exprName.toLowerCase(), k);
            String alias = selectItem.getAlias();
            if (alias != null) {
                aliasMap.put(alias.toLowerCase(), k);
            }
            ++k;
        }
        List<OrderByInfo.OrderByItem> orderByItems = sf.getOrderByInfo().getOrderByItems();
        List<GroupByInfo.GroupByItem> groupByItems = sf.getGroupByInfo().getGroupByItems();
        if (orderByItems.size() > 0 && orderByItems.size() == groupByItems.size()) {
            for (int i = 0; i < orderByItems.size(); ++i) {
                String groupByField;
                String orderByField = orderByItems.get(i).getField().toLowerCase();
                if (orderByField.equalsIgnoreCase(groupByField = groupByItems.get(i).getField().toLowerCase())) continue;
                Integer orderIndex = (Integer)aliasMap.get(orderByField);
                if (orderIndex == null) {
                    orderIndex = (Integer)exprNameMap.get(orderByField);
                }
                if (orderIndex == null) {
                    return false;
                }
                Integer groupIndex = (Integer)aliasMap.get(groupByField);
                if (groupIndex == null) {
                    groupIndex = (Integer)exprNameMap.get(groupByField);
                }
                if (groupIndex == null) {
                    return false;
                }
                if (groupIndex.equals(orderIndex)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public ShardingSQL[] sharding(StatementInfo stmtInfo, boolean shardingSubStmt) {
        Object tableConfig;
        KSQLIfExistsStatement ifStmt;
        SQLStatement execStmt;
        ShardingSQL originalShardingSQL = stmtInfo.shardingSQL();
        StatementType stmtType = stmtInfo.getStatementType();
        if (originalShardingSQL instanceof DDLShardingSQL) {
            TableInfo ti = stmtInfo.getTableInfos().get(0);
            String tableName = ti.getName();
            ShardingConfig tableConfig2 = this.scp.getConfig(tableName);
            if (tableConfig2 == null || !tableConfig2.isEnabled()) {
                return new ShardingSQL[]{originalShardingSQL};
            }
            switch (stmtType) {
                case drop_table: {
                    throw new IllegalArgumentException("Can not drop table directly under sharding: " + tableName);
                }
                case truncate: 
                case create_index: 
                case drop_index: 
                case alter_table: 
                case create_table: {
                    return originalShardingSQL.sharding(ti, tableConfig2.getShardingStrategy());
                }
            }
            throw new UnsupportedOperationException("Unsupport sharding DDL statement type: " + (Object)((Object)stmtType));
        }
        if (originalShardingSQL instanceof IfExistsShardingSQL && (execStmt = (ifStmt = (KSQLIfExistsStatement)stmtInfo.getSQLStatement()).getStatements().get(0)) instanceof MySqlCreateTableStatement) {
            String tableName = ((MySqlCreateTableStatement)execStmt).getTableSource().toString().toLowerCase();
            ShardingConfig tableConfig3 = this.scp.getConfig(tableName);
            TableInfo ti = null;
            for (TableInfo tableInfo : stmtInfo.getTableInfos()) {
                if (!tableInfo.getName().equalsIgnoreCase(tableName)) continue;
                ti = tableInfo;
                break;
            }
            if (tableConfig3 != null && tableConfig3.isEnabled() && ti != null) {
                return originalShardingSQL.sharding(ti, tableConfig3.getShardingStrategy());
            }
        }
        ArrayList<ShardingSQL> shardings = new ArrayList<ShardingSQL>();
        boolean withShardingTable = false;
        ArrayList<TableInfo> tis = new ArrayList<TableInfo>(stmtInfo.getTableInfos());
        ChildrenStrategy.sortTable(tis, this.scp);
        ArrayList<SQLExprTableSource> sameTableSourceList = new ArrayList<SQLExprTableSource>(tis.size());
        HashSet<ShardingConfig> configs = new HashSet<ShardingConfig>(16);
        HashMap<String, ShardingConfig> tableConfigMap = new HashMap<String, ShardingConfig>(16);
        for (TableInfo originalShardingSQLti : tis) {
            tableConfig = this.scp.getConfig(originalShardingSQLti.getName());
            if (tableConfig == null || !tableConfig.isEnabled()) continue;
            tableConfigMap.put(originalShardingSQLti.getName(), (ShardingConfig)tableConfig);
        }
        for (TableInfo originalShardingSQLti : tis) {
            tableConfig = this.scp.getConfig(originalShardingSQLti.getName());
            if (tableConfig == null || !tableConfig.isEnabled()) continue;
            boolean sharded = false;
            for (SQLExprTableSource sQLExprTableSource : sameTableSourceList) {
                if (sQLExprTableSource == originalShardingSQLti.getSQLTableSource()) {
                    sharded = true;
                    break;
                }
                if (!sharded) continue;
            }
            sameTableSourceList.add(originalShardingSQLti.getSQLTableSource());
            configs.add((ShardingConfig)tableConfig);
            if (!withShardingTable) {
                withShardingTable = true;
            }
            tableConfig.getShardingStrategy().ensureTableInited();
            MetricsCollector mc = MetricsCollector.getCurrent();
            if (shardings.isEmpty()) {
                shardings.addAll(Arrays.asList(this.shardingTable(originalShardingSQL, originalShardingSQLti, (ShardingConfig)tableConfig, configs, tableConfigMap, mc)));
                continue;
            }
            for (ShardingSQL shardingSQL : new ArrayList(shardings)) {
                ShardingSQL[] subShardings;
                if (!shardingSQL.canSharding()) continue;
                shardings.remove(shardingSQL);
                shardingSQL.getStatementInfo().refreshTableInfo();
                TableInfo shardingTable = null;
                for (TableInfo tableInfo : shardingSQL.getStatementInfo().getTableInfos()) {
                    if (tableInfo.getPosIndex() != originalShardingSQLti.getPosIndex()) continue;
                    shardingTable = tableInfo;
                    break;
                }
                for (ShardingSQL subSharding : subShardings = this.shardingTable(shardingSQL, shardingTable, (ShardingConfig)tableConfig, configs, tableConfigMap, mc)) {
                    shardings.add(subSharding);
                }
            }
        }
        if (!withShardingTable) {
            return new ShardingSQL[]{originalShardingSQL};
        }
        MetricsCollector metricsCollector = MetricsCollector.getCurrent();
        if (shardings.size() == 0) {
            ArrayList<String> prototypeTables = new ArrayList<String>(16);
            for (TableInfo ti : tis) {
                ShardingConfig tableConfig4 = this.scp.getConfig(ti.getName());
                if (tableConfig4 == null) continue;
                String string = TableName.of(ti.getName()).getPrototypeTable();
                ti.getSQLTableSource().setExpr(SQLUtil.wrapSQLTableName(string));
                prototypeTables.add(string);
            }
            if (metricsCollector.isActionMetricEnabled()) {
                ShardingEmptySpan sts = new ShardingEmptySpan(((Object)prototypeTables).toString());
                metricsCollector.actionMetric().stat(sts);
                if (log.isInfoEnabled()) {
                    log.info(sts.toString());
                }
            }
            if (shardingSubStmt) {
                return new ShardingSQL[0];
            }
            return new ShardingSQL[]{new FinalShardingSQL(stmtInfo)};
        }
        ShardingSQL[] ret = new ShardingSQL[shardings.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (ShardingSQL)shardings.get(i);
        }
        if (stmtInfo.isDelete()) {
            TableInfo shardingSourceTable = (TableInfo)tis.get(0);
            ShardingConfig sc = this.scp.getConfig(shardingSourceTable.getName());
            if (shardingSourceTable == stmtInfo.getTableInfos().get(0) && null != sc && sc.isIndexPK() && sc instanceof MainTableConfig) {
                ArrayList<ShardingSQL> all = new ArrayList<ShardingSQL>(ret.length * 2);
                for (ShardingSQL ss : ret) {
                    ShardingSQL shardingSQL = ((DeleteShardingSQL)ss).genDeleteShardingIndexPK(shardingSourceTable, sc.getShardingStrategy());
                    all.add(shardingSQL);
                }
                if (!all.isEmpty()) {
                    for (ShardingSQL ss : ret) {
                        all.add(ss);
                    }
                    ret = all.toArray(new ShardingSQL[all.size()]);
                    IndexPKStore indexPKStore = ((AbstractShardingStrategy)sc.getShardingStrategy()).getIndexPKStore();
                    if (indexPKStore != null) {
                        indexPKStore.clear(((MainTableConfig)sc).getGroupTables().toArray(new String[0]));
                    }
                }
            }
        }
        if (metricsCollector.isActionMetricEnabled()) {
            ArrayList<List<String>> shardingGroupTables = new ArrayList<List<String>>(shardings.size());
            for (ShardingSQL ss : shardings) {
                shardingGroupTables.add(ss.getShardingTables());
            }
            ShardingTableSpan sts = new ShardingTableSpan(shardingGroupTables, shardingSubStmt);
            metricsCollector.actionMetric().stat(sts);
        }
        return ret;
    }

    private ShardingSQL[] shardingTable(ShardingSQL shardingSQL, TableInfo shardingTable, ShardingConfig tableConfig, Set<ShardingConfig> configs, Map<String, ShardingConfig> tableConfigMap, MetricsCollector mc) {
        ShardingSQL[] sameLevelShardingSQLs;
        ShardingSQL[] childrenShardingSQLs;
        if (mc.isActionMetricEnabled()) {
            mc.actionMetric().getShardingTables().add(shardingTable.getName());
        }
        if (mc.isPerformanceMetricEnabled() && mc.performanceMetric().getBillNumber() == null) {
            if (!(tableConfig instanceof MainTableConfig)) {
                ShardingConfig parent = ((ChildrenTableConfig)tableConfig).getParent();
                while (parent instanceof ChildrenTableConfig) {
                    parent = ((ChildrenTableConfig)parent).getParent();
                }
                mc.performanceMetric().setBillNumber(parent.getName());
            } else {
                mc.performanceMetric().setBillNumber(tableConfig.getName());
            }
        }
        if (tableConfig instanceof ChildrenTableConfig && (childrenShardingSQLs = this.shardingChildrenTable(shardingSQL, shardingTable, tableConfig, configs, tableConfigMap)) != null) {
            return childrenShardingSQLs;
        }
        if (configs.contains(tableConfig) && (sameLevelShardingSQLs = this.shardingSameConfigTable(shardingSQL, shardingTable, tableConfig, configs, tableConfigMap)) != null) {
            return sameLevelShardingSQLs;
        }
        return shardingSQL.sharding(shardingTable, tableConfig.getShardingStrategy());
    }

    private ShardingSQL[] shardingSameConfigTable(ShardingSQL shardingSQL, TableInfo shardingTable, ShardingConfig tableConfig, Set<ShardingConfig> configs, Map<String, ShardingConfig> tableConfigMap) {
        List<TableInfo> tables = shardingSQL.getStatementInfo().getTableInfos();
        for (TableInfo tableInfo : tables) {
            TableName tableName = TableName.of(tableInfo.getName());
            if (!tableName.isDataTable() && !tableName.isPrototypeTable() || !tableName.getOriginalName().equals(shardingTable.getName())) continue;
            return new ShardingSQL[]{this.shardingWithTheSameTableInfo(shardingSQL, shardingTable, tableInfo)};
        }
        return null;
    }

    private ShardingSQL[] shardingChildrenTable(ShardingSQL shardingSQL, TableInfo shardingTable, ShardingConfig tableConfig, Set<ShardingConfig> configs, Map<String, ShardingConfig> tableConfigMap) {
        List<TableInfo> tables = shardingSQL.getStatementInfo().getTableInfos();
        for (TableInfo sameTI : tables) {
            boolean hasRef = false;
            TableInfo findTI = this.findJoinParentTableInfo(sameTI.getSQLTableSource(), tables);
            if (findTI == null) continue;
            if (sameTI == shardingTable) {
                sameTI = findTI;
                hasRef = true;
            } else if (findTI == shardingTable) {
                hasRef = true;
            }
            if (!hasRef) continue;
            TableName sameTN = TableName.of(sameTI.getSQLTableSource().getTableName());
            String originalName = TableName.of(sameTI.getName()).getOriginalName();
            if (!sameTN.isDataTable() && !sameTN.isPrototypeTable() || !this.hasSameMainShardingConfig(tableConfig, tableConfigMap.get(originalName))) continue;
            return new ShardingSQL[]{this.shardingWithTheSameTableInfo(shardingSQL, shardingTable, sameTI)};
        }
        ShardingConfig parentConfig = ((ChildrenTableConfig)tableConfig).getParent();
        if (!configs.contains(parentConfig) && parentConfig instanceof ChildrenTableConfig) {
            parentConfig = ((ChildrenTableConfig)parentConfig).getParent();
        }
        if (configs.contains(parentConfig)) {
            TableInfo parentTI = null;
            for (TableInfo ti : tables) {
                TableInfo findTI = this.findJoinParentTableInfo(ti.getSQLTableSource(), tables);
                if (findTI == null || !TableName.of(findTI.getName()).getOriginalName().equals(parentConfig.getTable())) continue;
                parentTI = findTI;
                break;
            }
            if (parentTI != null) {
                return new ShardingSQL[]{this.shardingWithTheSameTableInfo(shardingSQL, shardingTable, parentTI)};
            }
            if (XDBConfig.get().isShardingSameGroupTable()) {
                ShardingConfig root = tableConfig;
                while (root instanceof ChildrenTableConfig) {
                    root = ((ChildrenTableConfig)root).getParent();
                }
                Set<String> groupTables = ((MainTableConfig)root).getGroupTables();
                for (TableInfo sameTI : tables) {
                    TableName sameTN = TableName.of(sameTI.getSQLTableSource().getTableName());
                    if (!sameTN.isDataTable() && !sameTN.isPrototypeTable() || !groupTables.contains(sameTN.getOriginalName())) continue;
                    return new ShardingSQL[]{this.shardingWithTheSameTableInfo(shardingSQL, shardingTable, sameTI)};
                }
            }
        }
        return null;
    }

    private ShardingSQL shardingWithTheSameTableInfo(ShardingSQL shardingSQL, TableInfo shardingTable, TableInfo sameTI) {
        String curShardingTableName;
        TableName sameTN = TableName.of(sameTI.getName());
        TableName tn = TableName.of(shardingTable.getName());
        if (sameTN.isPrototypeTable()) {
            curShardingTableName = tn.getPrototypeTable();
        } else {
            String suffix = sameTN.getSuffix();
            curShardingTableName = tn.getShardingTable(suffix);
            StatementType type = shardingSQL.getStatementInfo().getStatementType();
            if (type == StatementType.select || type == StatementType.update || type == StatementType.delete) {
                try {
                    if (!XDBConfig.getTableManager().existTable(curShardingTableName)) {
                        curShardingTableName = tn.getPrototypeTable();
                    }
                }
                catch (SQLException e) {
                    throw ExceptionUtil.wrap(e);
                }
            }
        }
        shardingTable.getSQLTableSource().setExpr(SQLUtil.wrapSQLTableName(curShardingTableName));
        this.resolveSQLPropertyExprOwner(shardingSQL.getStatementInfo().getSQLStatement());
        shardingSQL.getSQLInfo().setSql(shardingSQL.getStatementInfo().getSQLStatement().toString());
        return shardingSQL;
    }

    private boolean hasSameMainShardingConfig(ShardingConfig tableConfig1, ShardingConfig tableConfig2) {
        while (tableConfig1 instanceof ChildrenTableConfig) {
            tableConfig1 = ((ChildrenTableConfig)tableConfig1).getParent();
        }
        while (tableConfig2 instanceof ChildrenTableConfig) {
            tableConfig2 = ((ChildrenTableConfig)tableConfig2).getParent();
        }
        return tableConfig1 == tableConfig2 || tableConfig1.getEntitynumber().equalsIgnoreCase(tableConfig2.getEntitynumber());
    }

    private TableInfo findJoinParentTableInfo(SQLExprTableSource curTableSource, List<TableInfo> tables) {
        SQLTableSource parent;
        SQLObject parentSQLObject = curTableSource.getParent();
        if (parentSQLObject == null) {
            return null;
        }
        if (parentSQLObject instanceof SQLStatement) {
            return null;
        }
        SQLTableSource parentFrom = null;
        if (parentSQLObject instanceof SQLSelectQueryBlock) {
            parentFrom = ((SQLSelectQueryBlock)parentSQLObject).getFrom();
        }
        if (parentSQLObject instanceof SQLDeleteStatement) {
            parentFrom = ((SQLDeleteStatement)parentSQLObject).getFrom();
        }
        if (parentSQLObject instanceof SQLUpdateStatement) {
            parentFrom = ((SQLUpdateStatement)parentSQLObject).getFrom();
        }
        if (parentFrom != null) {
            TableName tn;
            if (parentFrom instanceof SQLExprTableSource && ((tn = TableName.of(((SQLExprTableSource)parentFrom).getTableName())).isDataTable() || tn.isPrototypeTable())) {
                for (TableInfo ti : tables) {
                    if (!TableName.of(ti.getName()).getOriginalName().equals(tn.getOriginalName())) continue;
                    return ti;
                }
            }
            return null;
        }
        SQLJoinTableSource join = (SQLJoinTableSource)curTableSource.getParent();
        SQLTableSource sQLTableSource = parent = curTableSource == join.getLeft() ? join.getRight() : join.getLeft();
        if (!(parent instanceof SQLExprTableSource) && parent instanceof SQLJoinTableSource) {
            SQLBinaryOpExpr condition = (SQLBinaryOpExpr)join.getCondition();
            parent = this.findJoinTableSourceByCondition(condition, (SQLTableSource)curTableSource);
        }
        for (TableInfo ti : tables) {
            if (ti.getSQLTableSource() != parent) continue;
            return ti;
        }
        return null;
    }

    private SQLTableSource findJoinTableSourceByCondition(SQLBinaryOpExpr condition, SQLTableSource curTableSource) {
        if (SQLBinaryOperator.Equality == condition.getOperator()) {
            SQLExpr left = condition.getLeft();
            if (left instanceof SQLPropertyExpr) {
                SQLTableSource leftTableSource = ((SQLPropertyExpr)left).getResolvedTableSource();
                SQLExpr right = condition.getRight();
                if (right instanceof SQLPropertyExpr) {
                    SQLTableSource rightTableSource = ((SQLPropertyExpr)right).getResolvedTableSource();
                    if (leftTableSource == curTableSource) {
                        return rightTableSource;
                    }
                    if (rightTableSource == curTableSource) {
                        return leftTableSource;
                    }
                }
            }
        } else if (SQLBinaryOperator.BooleanAnd == condition.getOperator()) {
            SQLTableSource ret = this.findJoinTableSourceByCondition((SQLBinaryOpExpr)condition.getLeft(), curTableSource);
            if (ret == null) {
                ret = this.findJoinTableSourceByCondition((SQLBinaryOpExpr)condition.getRight(), curTableSource);
            }
            return ret;
        }
        return null;
    }

    private void resolveSQLPropertyExprOwner(SQLStatement stmt) {
        stmt.accept((SQLASTVisitor)new ResolvePropertyOwnerVisitor());
    }

    @Override
    public ShardingConfigProvider getShardingConfigProvider() {
        return this.scp;
    }

    ShardingSQLCache getShardingSQLCache() {
        return this.ssf.getShardingSQLCache();
    }
}

