/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.eventbus.Event;
import kd.bos.xdb.eventbus.EventBusDispatcher;
import kd.bos.xdb.eventbus.EventBusImpl;
import kd.bos.xdb.eventbus.EventHandler;
import kd.bos.xdb.eventbus.EventStore;

public final class EventBus {
    public static final String DEFAULT_CHANNEL = "default";
    private static final Map<String, EventBusDispatcher> channelDispatcherMap = new ConcurrentHashMap<String, EventBusDispatcher>();

    public static final void startService(String ... channels) {
        if (channels != null && channels.length > 0) {
            for (String channel : channels) {
                if (channel == null) continue;
                EventBus.startDispatcher(channel);
            }
        } else {
            EventBus.startDispatcher(DEFAULT_CHANNEL);
        }
    }

    private static final void startDispatcher(String channel) {
        channelDispatcherMap.computeIfAbsent(channel, k -> {
            EventBusDispatcher dis = new EventBusDispatcher(new EventStore((String)k));
            dis.start();
            return dis;
        });
    }

    public static void publish(Event event) {
        EventBus.publish(DEFAULT_CHANNEL, event);
    }

    public static <T extends Event> void subscribe(Class<T> event, EventHandler<T> handler) {
        EventBus.subscribe(DEFAULT_CHANNEL, event, handler);
    }

    public static <T extends Event> void unSubscribe(Class<T> event, EventHandler<T> handler) {
        EventBus.unSubscribe(DEFAULT_CHANNEL, event, handler);
    }

    public static void publish(String channel, Event event) {
        EventBusImpl.publish(channel, event);
    }

    public static <T extends Event> void subscribe(String channel, Class<T> event, EventHandler<T> handler) {
        EventBusImpl.subscribe(channel, event, handler);
    }

    public static <T extends Event> void unSubscribe(String channel, Class<T> event, EventHandler<T> handler) {
        EventBusImpl.unSubscribe(channel, event, handler);
    }
}

