/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus;

import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.instance.Instance;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.eventbus.Event;
import kd.bos.xdb.eventbus.EventBusImpl;
import kd.bos.xdb.eventbus.EventStore;
import kd.bos.xdb.eventbus.RedisErrorChangeDispatcherListener;
import kd.bos.xdb.util.Pair;

final class EventBusDispatcher
implements Runnable,
XDBLogable {
    private static final String instanceId = Instance.getInstanceId();
    private static final int pull_interval = 10000;
    private final Object snooper = new Object();
    private EventStore es;
    private final String channel;
    private volatile long consumedEventSeq = 0L;

    EventBusDispatcher(EventStore es) {
        this.es = es;
        this.channel = es.getChannel();
        RedisErrorChangeDispatcherListener listener = new RedisErrorChangeDispatcherListener(this);
        KeepAliveService.registerKeepAliveListener((KeepAliveListener)listener);
    }

    void start() {
        this.consumedEventSeq = this.es.getMaxEventSeq() + 1L;
        this.es.addMaxEventSeqChangeListener(seq -> {
            if (this.consumedEventSeq != seq) {
                Object object = this.snooper;
                synchronized (object) {
                    this.snooper.notifyAll();
                }
            }
        });
        Thread t = new Thread(this);
        t.setName("XDBEventBus-" + this.channel);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void run() {
        Thread t = Thread.currentThread();
        block2: while (!t.isInterrupted()) {
            try {
                this.snoop();
                while (true) {
                    Pair<Long, Event> eventPair = this.es.consumeEvent(this.consumedEventSeq);
                    this.consumedEventSeq = eventPair.getKey();
                    Event event = eventPair.getValue();
                    if (event == null) continue block2;
                    if (event.isIgnoreConsumeByMySelf() && instanceId.equals(event.getInstanceId())) continue;
                    EventBusImpl.onReceiveEvent(this.channel, event);
                }
            }
            catch (Exception e) {
                log.error("EventBusDispatcher error: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snoop() {
        Object object = this.snooper;
        synchronized (object) {
            try {
                this.snooper.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public EventStore getEventStore() {
        return this.es;
    }

    public void setEventStore(EventStore es) {
        this.es = es;
    }
}

