/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.eventbus.Event;
import kd.bos.xdb.eventbus.EventHandler;
import kd.bos.xdb.eventbus.EventStore;
import kd.bos.xdb.eventbus.RedisErrorChangeEventBusListener;
import kd.bos.xdb.eventbus.RequestContextInfo;

final class EventBusImpl
implements XDBLogable {
    private static final Map<String, EventBusImpl> channelEventBusMap = new ConcurrentHashMap<String, EventBusImpl>();
    private final Map<Class, List<EventHandler>> handlerMap = new ConcurrentHashMap<Class, List<EventHandler>>();
    private EventStore es;

    private static EventBusImpl get(String channel) {
        EventBusImpl eb = channelEventBusMap.get(channel);
        if (eb == null) {
            eb = channelEventBusMap.computeIfAbsent(channel, k -> new EventBusImpl((String)k));
        }
        return eb;
    }

    static void publish(String channel, Event event) {
        EventBusImpl.get(channel).publish(event);
    }

    static <T extends Event> void subscribe(String channel, Class<T> event, EventHandler<T> handler) {
        EventBusImpl.get(channel).subscribe(event, handler);
    }

    static <T extends Event> void unSubscribe(String channel, Class<T> event, EventHandler<T> handler) {
        EventBusImpl.get(channel).unSubscribe(event, handler);
    }

    static void onReceiveEvent(String channel, Event event) {
        EventBusImpl.get(channel).onReceiveEvent(event);
    }

    private EventBusImpl(String channel) {
        this.es = new EventStore(channel);
        RedisErrorChangeEventBusListener listener = new RedisErrorChangeEventBusListener(this);
        KeepAliveService.registerKeepAliveListener((KeepAliveListener)listener);
    }

    public EventStore getEventStore() {
        return this.es;
    }

    private void publish(Event event) {
        event.setRequestContextInfo(RequestContextInfo.get());
        this.es.publish(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveEvent(Event event) {
        List<EventHandler> list = this.handlerMap.get(event.getClass());
        if (list != null && !list.isEmpty()) {
            for (EventHandler handler : list) {
                try {
                    AutoCloseable ac = event.getRequestContextInfo().setupThreadRequestContext();
                    Throwable throwable = null;
                    try {
                        handler.handle(event);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ac == null) continue;
                        if (throwable != null) {
                            try {
                                ac.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ac.close();
                    }
                }
                catch (Exception e) {
                    log.error("Handle event " + event.getClass().getName() + " error: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    ThreadLocals.release();
                }
            }
        } else {
            log.error("Not found subscribed event handler: " + event.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Event> void subscribe(Class<T> event, EventHandler<T> handler) {
        Class<T> clazz = event;
        synchronized (clazz) {
            List<EventHandler> list = this.handlerMap.get(event);
            if (list == null) {
                list = new ArrayList<EventHandler>();
                list.add(handler);
                this.handlerMap.put(event, list);
            } else if (!list.contains(handler)) {
                ArrayList<EventHandler> newList = new ArrayList<EventHandler>(list);
                newList.add(handler);
                this.handlerMap.put(event, newList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Event> void unSubscribe(Class<T> event, EventHandler<T> handler) {
        Class<T> clazz = event;
        synchronized (clazz) {
            List<EventHandler> list = this.handlerMap.get(event);
            if (list != null) {
                ArrayList<EventHandler> newList = new ArrayList<EventHandler>(list);
                newList.remove(handler);
                this.handlerMap.put(event, newList);
            }
        }
    }
}

