/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus;

import java.util.ArrayList;
import java.util.List;
import kd.bos.config.client.util.ConfigUtils;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.xdb.endpoint.EndPointValueChangeService;
import kd.bos.xdb.endpoint.EndPointValueNotifier;
import kd.bos.xdb.eventbus.Event;
import kd.bos.xdb.eventbus.MaxEventSeqChangeListener;
import kd.bos.xdb.eventbus.StoreBase;
import kd.bos.xdb.eventbus.db.ClusterDBStore;
import kd.bos.xdb.eventbus.redis.ClusterRedisStore;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.util.Pair;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;

final class EventStore {
    private static final int eventBucketSize = 10000;
    private static final String ZK_URL;
    private static final String ZK_WATCHER_ROOT_PATH;
    protected static boolean excludeZk;
    private final String ZK_WATCH_KEY;
    private StoreBase rs;
    private final List<MaxEventSeqChangeListener> cl = new ArrayList<MaxEventSeqChangeListener>();
    private final String channel;
    private final int expireSeconds;

    EventStore() {
        this("default");
    }

    EventStore(String channel) {
        this(channel, 600);
    }

    EventStore(String channel, int expireSeconds) {
        this.channel = channel;
        this.expireSeconds = expireSeconds;
        this.ZK_WATCH_KEY = "XDBEventBus#EventMaxSeq#" + channel;
        this.rs = ComponentStatusManager.isException((String)ConfigurationUtil.getString((String)"redis.serversForCache")) ? new ClusterDBStore("XDBEventBus#" + channel + '#', expireSeconds) : new ClusterRedisStore("XDBEventBus#" + channel + '#', expireSeconds);
        if (excludeZk) {
            ConfigurationChangeListener listener = new ConfigurationChangeListener(){

                public void onChange(Object key, Object newValue) {
                    String s;
                    Long seq = 0L;
                    if (newValue != null && (s = newValue.toString()).matches("\\d+")) {
                        seq = Long.parseLong(s);
                    }
                    for (MaxEventSeqChangeListener l : EventStore.this.cl) {
                        l.onChanged(seq);
                    }
                }
            };
            EndPointValueChangeService.observeChange(this.ZK_WATCH_KEY, listener);
        } else {
            ConfigurationUtil.observeLong((String)this.ZK_WATCH_KEY, (long)0L, seq -> {
                for (MaxEventSeqChangeListener l : this.cl) {
                    l.onChanged((long)seq);
                }
            });
        }
    }

    public void setStoreBase(StoreBase rs) {
        this.rs = rs;
    }

    public StoreBase getStoreBase() {
        return this.rs;
    }

    void addMaxEventSeqChangeListener(MaxEventSeqChangeListener l) {
        this.cl.add(l);
    }

    String getChannel() {
        return this.channel;
    }

    public int getExpireSeconds() {
        return this.expireSeconds;
    }

    private String getEventBucket(long seq) {
        return "eventsBucket" + seq % 10000L;
    }

    void publish(Event event) {
        long seq = this.incMaxEventSeq();
        this.rs.mapSet(this.getEventBucket(seq), String.valueOf(seq), event);
        this.setZKWatchValue(this.ZK_WATCH_KEY, String.valueOf(seq));
    }

    Pair<Long, Event> consumeEvent(long currentConsumedEventSeq) {
        long max = this.getMaxEventSeq();
        while (++currentConsumedEventSeq <= max) {
            Event ret = (Event)this.rs.mapGet(this.getEventBucket(currentConsumedEventSeq), String.valueOf(currentConsumedEventSeq));
            if (ret == null) continue;
            return new Pair<Long, Event>(currentConsumedEventSeq, ret);
        }
        return new Pair<Long, Object>(max, null);
    }

    long getMaxEventSeq() {
        return this.rs.getInc("maxEventSeq");
    }

    private long incMaxEventSeq() {
        long seq = this.rs.inc("maxEventSeq", 1L, Integer.MAX_VALUE);
        if (seq < 0L) {
            seq = 0L;
            this.rs.set("maxEventSeq", 0);
        }
        return seq;
    }

    private void setZKWatchValue(String key, String value) {
        try {
            if (excludeZk) {
                EndPointValueChangeService.receiveValueChange(key, value);
                EndPointValueNotifier.endPointFireChange(key, value);
            } else {
                String fullPath = ZK_WATCHER_ROOT_PATH + key;
                CuratorFramework zkClient = ZKFactory.getZKClient((String)ZK_URL);
                if (zkClient.checkExists().forPath(fullPath) == null) {
                    zkClient.create().forPath(fullPath, value.getBytes());
                } else {
                    zkClient.setData().forPath(fullPath, value.getBytes());
                }
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    static {
        excludeZk = false;
        excludeZk = !"zookeeper".equalsIgnoreCase(ConfigUtils.getConfigUrlType()) || Boolean.getBoolean("xdb.exclude.zk");
        ZK_URL = System.getProperty("configUrl");
        ZK_WATCHER_ROOT_PATH = ConfigUtils.getCommonPropertyPath((String)Instance.getClusterName()) + "/";
    }
}

