/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus;

import java.io.Serializable;
import java.lang.reflect.Method;
import kd.bos.bundle.Resources;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.exception.ExceptionUtil;

public class RequestContextInfo
implements Serializable {
    private static final long serialVersionUID = 6947298389985750510L;
    private static Method requestContext_get;
    private static Method requestContext_set;
    private static Method requestContext_setTenantId;
    private static Method requestContext_getTenantId;
    private static Method requestContext_setAccountId;
    private static Method requestContext_getAccountId;
    private static Method requestContext_createAndSet;
    private static Method requestContext_getSetStack;
    private static final ThreadLocal<RequestContextInfo> th;
    private Object rc;
    private final String tenantId;
    private final String accountId;

    public static RequestContextInfo get() {
        try {
            Object rc = requestContext_get.invoke(null, new Object[0]);
            if (rc == null) {
                IllegalThreadStateException e = new IllegalThreadStateException(Resources.get((String)"bos-dbengine", (String)"RequestContextInfo_0", (String)"RequestContext\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ebf\u7a0b\u73af\u5883\u662f\u5426\u6b63\u786e\u3002", (Object[])new Object[0]));
                throw e;
            }
            RequestContextInfo ret = th.get();
            if (ret == null || ret.rc != rc) {
                ret = new RequestContextInfo((String)requestContext_getTenantId.invoke(rc, new Object[0]), (String)requestContext_getAccountId.invoke(rc, new Object[0]));
                ret.rc = rc;
                th.set(ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }

    public static Object getRequestContext() {
        try {
            return requestContext_get.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }

    public static String getRequestContextSetStack() {
        try {
            return (String)requestContext_getSetStack.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }

    public RequestContextInfo(String tenantId, String accountId) {
        this.tenantId = tenantId;
        this.accountId = accountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public AutoCloseable setupThreadRequestContext() {
        try {
            Object oldRequestContext = requestContext_get.invoke(null, new Object[0]);
            Object rc = requestContext_createAndSet.invoke(null, Boolean.TRUE);
            requestContext_setTenantId.invoke(rc, this.tenantId);
            requestContext_setAccountId.invoke(rc, this.accountId);
            return () -> requestContext_set.invoke(null, oldRequestContext);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }

    public String toString() {
        return this.tenantId + "#" + this.accountId;
    }

    static {
        th = ThreadLocals.create();
        try {
            Class<?> requestContextCls = Class.forName("kd.bos.context.RequestContext");
            requestContext_getTenantId = requestContextCls.getMethod("getTenantId", new Class[0]);
            requestContext_getAccountId = requestContextCls.getMethod("getAccountId", new Class[0]);
            requestContext_setTenantId = requestContextCls.getMethod("setTenantId", String.class);
            requestContext_setAccountId = requestContextCls.getMethod("setAccountId", String.class);
            requestContext_get = requestContextCls.getMethod("get", new Class[0]);
            requestContext_set = requestContextCls.getMethod("set", requestContextCls);
            requestContext_createAndSet = requestContextCls.getMethod("create", Boolean.TYPE);
            requestContext_getSetStack = requestContextCls.getMethod("getSetStack", new Class[0]);
            requestContext_getTenantId.setAccessible(true);
            requestContext_getAccountId.setAccessible(true);
            requestContext_setTenantId.setAccessible(true);
            requestContext_setAccountId.setAccessible(true);
            requestContext_get.setAccessible(true);
            requestContext_set.setAccessible(true);
            requestContext_createAndSet.setAccessible(true);
            requestContext_getSetStack.setAccessible(true);
        }
        catch (Exception e) {
            throw ExceptionUtil.asRuntimeException(e);
        }
    }
}

