/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import kd.bos.bundle.Resources;
import kd.bos.xdb.exception.XdbException;

public final class ExceptionUtil {
    public static String getStackTrace(String msg) {
        return ExceptionUtil.getStackTrace(new XdbException(msg));
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static RuntimeException asRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static RuntimeException asRuntimeException(String msg, Throwable e) {
        return new RuntimeException(msg, e);
    }

    public static XdbException wrap(String msg) {
        return new XdbException(msg);
    }

    public static XdbException wrap(Throwable e) {
        if (e instanceof XdbException) {
            return (XdbException)e;
        }
        return new XdbException(e);
    }

    public static XdbException wrap(String msg, Throwable e) {
        return new XdbException(msg, e);
    }

    public static <T extends Exception> T as(Class<T> type, Throwable e) {
        Constructor<?>[] cs;
        if (type.isAssignableFrom(e.getClass())) {
            return (T)((Exception)e);
        }
        for (Constructor<?> c : cs = type.getConstructors()) {
            if (c.getParameterCount() != 1 || !Throwable.class.isAssignableFrom(c.getParameterTypes()[0])) continue;
            try {
                return (T)((Exception)c.newInstance(e));
            }
            catch (Exception e1) {
                throw ExceptionUtil.wrap(e);
            }
        }
        throw new XdbException(Resources.get((String)"bos-xdb", (String)"ExceptionUtil_0", (String)"\u5f02\u5e38\u7c7b{0}\u65e0\u9002\u5408\u7684\u6784\u9020\u65b9\u6cd5\u3002", (Object[])new Object[]{type}));
    }

    public static <T extends Exception> T as(Class<T> type, String msg, Throwable e) {
        Constructor<?>[] cs;
        if (type.isAssignableFrom(e.getClass())) {
            return (T)((Exception)e);
        }
        for (Constructor<?> c : cs = type.getConstructors()) {
            if (c.getParameterCount() != 2 || !String.class.isAssignableFrom(c.getParameterTypes()[0]) || !Throwable.class.isAssignableFrom(c.getParameterTypes()[1])) continue;
            try {
                return (T)((Exception)c.newInstance(msg, e));
            }
            catch (Exception e1) {
                throw ExceptionUtil.wrap(e);
            }
        }
        throw new XdbException(Resources.get((String)"bos-xdb", (String)"ExceptionUtil_0", (String)"\u5f02\u5e38\u7c7b{0}\u65e0\u9002\u5408\u7684\u6784\u9020\u65b9\u6cd5\u3002", (Object[])new Object[]{type}));
    }
}

