/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.hint;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.ShardingEngine;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.strategy.AbstractShardingStrategy;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.spare.IndexPKSpareStrategy;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.util.SQLUtil;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class ShardingHintContext
implements AutoCloseable {
    private static final String prefix = "/*XDB:SHARDING:";
    private static final String table_barrier = "table_barrier";
    private static final String batch_sharding = "batch_sharding";
    private static final String suffix = "*/";
    static final char encode_delim = ':';
    private static final ThreadLocal<ShardingHintContext> th = ThreadLocals.create();
    private final boolean barrier;
    private final String hintTable;
    private boolean batchSharding;
    private final Map<String, List<HintCondition>> cmap;
    private final transient Map<ShardingConfig, SQLInfo> exerciseShardingSQLCache;
    private transient boolean prepareShardingIndex;
    private transient boolean cacheHintShardingIndex = true;
    private transient long[] cacheRet;
    private transient String shardingHint;
    private transient boolean skipHint;
    private transient boolean usingHint;
    private transient ShardingHintContext parent;

    @Deprecated
    @SdkInternal
    public static ShardingHintContext create(String hintTable, ShardingHintCondition ... hintConditions) {
        if (hintConditions == null || hintConditions.length == 0) {
            return ShardingHintContext.create(hintTable, (HintCondition[])null);
        }
        HintCondition[] hs = new HintCondition[hintConditions.length];
        System.arraycopy(hintConditions, 0, hs, 0, hs.length);
        return ShardingHintContext.create(hintTable, hs);
    }

    @Deprecated
    @SdkInternal
    public static ShardingHintContext createAndSet(String hintTable, ShardingHintCondition ... hintConditions) {
        ShardingHintContext ctx = ShardingHintContext.create(hintTable, hintConditions);
        ctx.set();
        return ctx;
    }

    public static ShardingHintContext create(String hintTable, HintCondition ... hintConditions) {
        return new ShardingHintContext(hintTable, hintConditions);
    }

    public static ShardingHintContext createAndSet(String hintTable, HintCondition ... hintConditions) {
        ShardingHintContext ctx = new ShardingHintContext(hintTable, hintConditions);
        ctx.set();
        return ctx;
    }

    @SdkInternal
    public static ShardingHintContext createBarrier() {
        return ShardingHintContext.create(table_barrier, (HintCondition[])null);
    }

    @SdkInternal
    public static ShardingHintContext createBarrierAndSet() {
        return ShardingHintContext.createAndSet(table_barrier, (HintCondition[])null);
    }

    @SdkInternal
    public static ShardingHintContext get() {
        return th.get();
    }

    public static boolean canHintNestedIfExistsGroupHintTable(String groupHintTable) {
        ShardingHintContext ctx = th.get();
        if (ctx != null) {
            groupHintTable = groupHintTable.toLowerCase();
            ShardingConfig shardingConfig = XDBConfig.getShardingConfigProvider().getConfig(groupHintTable);
            if (shardingConfig == null) {
                return false;
            }
            if (shardingConfig instanceof MainTableConfig) {
                return true;
            }
            if (ctx.hintTable.equals(groupHintTable)) {
                return true;
            }
            ShardingConfig ctxShardingConfig = XDBConfig.getShardingConfigProvider().getConfig(ctx.hintTable);
            if (ctxShardingConfig instanceof MainTableConfig) {
                return !((MainTableConfig)ctxShardingConfig).getGroupTables().contains(groupHintTable);
            }
            while (shardingConfig instanceof ChildrenTableConfig) {
                if ((shardingConfig = ((ChildrenTableConfig)shardingConfig).getParent()) != ctxShardingConfig && !shardingConfig.getTable().equals(ctx.hintTable)) continue;
                return false;
            }
        }
        return true;
    }

    private ShardingHintContext(String hintTable, HintCondition ... cs) {
        this.hintTable = hintTable.toLowerCase();
        this.barrier = table_barrier.equals(this.hintTable);
        if (this.barrier) {
            this.cmap = null;
            this.exerciseShardingSQLCache = null;
        } else {
            this.cmap = new HashMap<String, List<HintCondition>>();
            this.exerciseShardingSQLCache = new HashMap<ShardingConfig, SQLInfo>();
            if (cs != null) {
                for (HintCondition c : cs) {
                    List<HintCondition> list = this.cmap.get(c.field);
                    if (list == null) {
                        list = new ArrayList<HintCondition>();
                        this.cmap.put(c.field, list);
                    }
                    list.add(c);
                }
            }
        }
    }

    public void set() {
        this.parent = th.get();
        th.set(this);
    }

    public ShardingHintContext prepareShardingIndex() {
        this.prepareShardingIndex = true;
        return this;
    }

    public boolean isPrepareShardingIndex() {
        return this.prepareShardingIndex;
    }

    @SdkInternal
    public boolean isBarrier() {
        return this.barrier;
    }

    @SdkInternal
    public boolean isSkipHint() {
        return this.skipHint || this.barrier;
    }

    @SdkInternal
    public void setSkipHint(boolean skipHint) {
        this.skipHint = skipHint;
    }

    public boolean isBatchShardingEnabled() {
        return this.batchSharding;
    }

    public void setBatchShardingEnabled(boolean batchSharding) {
        this.batchSharding = batchSharding;
    }

    @SdkInternal
    public ShardingHintContext cacheHintShardingIndex(boolean cacheHintShardingIndex) {
        this.cacheHintShardingIndex = cacheHintShardingIndex;
        return this;
    }

    @SdkInternal
    public boolean isHintForTable(String table) {
        if (this.hintTable.equals(table = table.toLowerCase())) {
            return true;
        }
        ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(table);
        while (config instanceof ChildrenTableConfig) {
            if (!(config = ((ChildrenTableConfig)config).getParent()).getTable().equals(this.hintTable)) continue;
            return true;
        }
        return false;
    }

    @SdkInternal
    public List<HintCondition> effectiveHintCondition(ShardingConfig config) {
        if (this.barrier || this.skipHint || this.cmap.isEmpty()) {
            return null;
        }
        if (!this.isConfigMatchHinttable(config)) {
            return null;
        }
        ShardingConfig hintConfig = this.findHintConfig();
        if (hintConfig == null) {
            return null;
        }
        if (!hintConfig.getTable().equals(config.getTable())) {
            if (config instanceof ChildrenTableConfig) {
                ShardingConfig parentConfig = ((ChildrenTableConfig)config).getParent();
                if (!hintConfig.getTable().equals(parentConfig.getTable())) {
                    return null;
                }
                if (!(hintConfig.getShardingStrategy() instanceof IndexPKSpareStrategy)) {
                    return null;
                }
            } else {
                return null;
            }
        }
        String[] shardingFields = hintConfig.getShardingFields();
        int n = shardingFields.length;
        ArrayList<HintCondition> conditionList = new ArrayList<HintCondition>(1);
        for (int i = 0; i < n; ++i) {
            String field = shardingFields[i];
            for (HintCondition c : this.cmap.get(field)) {
                conditionList.add(c);
            }
        }
        return conditionList;
    }

    @SdkInternal
    public long[] tryShardingIndex(ShardingConfig config) {
        if (this.barrier || this.skipHint || this.usingHint || this.cmap.isEmpty()) {
            return null;
        }
        if (!this.isConfigMatchHinttable(config)) {
            return null;
        }
        if (this.cacheHintShardingIndex) {
            if (this.cacheRet == null) {
                this.usingHint = true;
                this.cacheRet = this.doShardingIndex(config);
                this.usingHint = false;
            }
            return this.cacheRet;
        }
        this.usingHint = true;
        long[] noCacheRet = this.doShardingIndex(config);
        this.usingHint = false;
        return noCacheRet;
    }

    private long[] doShardingIndex(ShardingConfig config) {
        ShardingConfig hintConfig = this.findHintConfig();
        if (hintConfig == null) {
            return null;
        }
        SQLInfo exerciseSI = this.exerciseShardingSQLCache.get(config);
        if (exerciseSI == null) {
            StringBuilder exerciseShardingSQL = new StringBuilder(128);
            exerciseShardingSQL.append("select 1 from ").append(this.hintTable).append(" where ");
            String[] shardingFields = hintConfig.getShardingFields();
            int n = shardingFields.length;
            ArrayList<Object> params = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                String field = shardingFields[i];
                List<HintCondition> hintConditionList = this.cmap.get(field);
                int hn = hintConditionList.size();
                block8: for (int k = 0; k < hn; ++k) {
                    HintCondition c = hintConditionList.get(k);
                    FilterType ft = c.filterType;
                    Object[] value = c.value;
                    if (value == null) {
                        throw new UnsupportedOperationException("Sharding hint field value can not be null: " + field);
                    }
                    if (value instanceof Collection) {
                        value = ((Collection)value).toArray();
                    } else if (value instanceof Iterable) {
                        ArrayList list = new ArrayList();
                        Iterator iter = ((Iterable)value).iterator();
                        while (iter.hasNext()) {
                            list.add(iter.next());
                        }
                        value = list.toArray();
                    }
                    if (!(ft != FilterType.in_range && ft != FilterType.not_in_range || value.getClass().isArray())) {
                        ft = ft == FilterType.in_range ? FilterType.eq : FilterType.not_eq;
                    }
                    if (i > 0 || k > 0) {
                        exerciseShardingSQL.append(" and ");
                    }
                    switch (ft) {
                        case between_and: {
                            exerciseShardingSQL.append(field).append(" between ? and ?");
                            params.add(Array.get(value, 0));
                            params.add(Array.get(value, 1));
                            continue block8;
                        }
                        case not_between_and: {
                            exerciseShardingSQL.append(field).append(" not between ? and ?");
                            params.add(Array.get(value, 0));
                            params.add(Array.get(value, 1));
                            continue block8;
                        }
                        case in_range: {
                            int len = Array.getLength(value);
                            if (len == 0) {
                                exerciseShardingSQL.append("1!=1");
                                continue block8;
                            }
                            if (len == 1) {
                                exerciseShardingSQL.append(field).append("=?");
                                params.add(Array.get(value, 0));
                                continue block8;
                            }
                            exerciseShardingSQL.append(SQLUtil.inSQL(field, len));
                            for (int j = 0; j < len; ++j) {
                                params.add(Array.get(value, j));
                            }
                            continue block8;
                        }
                        case not_in_range: {
                            int len = Array.getLength(value);
                            if (len == 0) {
                                exerciseShardingSQL.append("1=1");
                                continue block8;
                            }
                            if (len == 1) {
                                exerciseShardingSQL.append(field).append("!=?");
                                params.add(Array.get(value, 0));
                                continue block8;
                            }
                            exerciseShardingSQL.append(SQLUtil.notInSQL(field, len));
                            for (int j = 0; j < len; ++j) {
                                params.add(Array.get(value, j));
                            }
                            continue block8;
                        }
                        case eq: 
                        case ge: 
                        case gt: 
                        case le: 
                        case like: 
                        case lt: 
                        case not_eq: 
                        case not_like: {
                            exerciseShardingSQL.append(field).append(ft.getCP()).append('?');
                            params.add(value);
                            continue block8;
                        }
                        default: {
                            throw new UnsupportedOperationException("Not support sharding hint comparator: " + (Object)((Object)ft));
                        }
                    }
                }
            }
            exerciseSI = new SQLInfo(exerciseShardingSQL.toString(), params.toArray(), false);
            this.exerciseShardingSQLCache.put(config, exerciseSI);
        }
        ShardingEngine engine = ShardingEngineFactory.get();
        ShardingResult sr = engine.sharding(exerciseSI.getSql(), exerciseSI.getParams());
        ArrayList<Long> indexies = new ArrayList<Long>(sr.getSQLInfos().length);
        StringBuilder sb = new StringBuilder(8);
        for (SQLInfo si : sr.getSQLInfos()) {
            String s = si.getSql();
            s = s.substring(s.indexOf(36) + 1);
            for (char ch : s.toCharArray()) {
                if (!Character.isDigit(ch)) break;
                sb.append(ch);
            }
            if (sb.length() <= 0) continue;
            indexies.add(Long.parseLong(sb.toString()));
            sb.setLength(0);
        }
        return ArrayUtil.toArray(indexies);
    }

    private boolean isMatchFields(ShardingConfig config) {
        String[] shardingFields;
        for (String f : shardingFields = config.getShardingFields()) {
            if (this.cmap.containsKey(f)) continue;
            return false;
        }
        return true;
    }

    private boolean isConfigMatchHinttable(ShardingConfig config) {
        while (config instanceof ChildrenTableConfig) {
            config = ((ChildrenTableConfig)config).getParent();
        }
        return ((MainTableConfig)config).getGroupTables().contains(this.hintTable);
    }

    public ShardingConfig findHintConfig() {
        ShardingConfig hintConfig = XDBConfig.getShardingConfigProvider().getConfig(this.hintTable);
        if (!this.isMatchFields(hintConfig)) {
            boolean fit = false;
            for (ShardingStrategy shardingStrategy : ((AbstractShardingStrategy)hintConfig.getShardingStrategy()).getCreateSpareStrategies()) {
                if (!this.isMatchFields(shardingStrategy.getConfig())) continue;
                hintConfig = shardingStrategy.getConfig();
                fit = true;
                break;
            }
            if (!fit) {
                return null;
            }
        }
        return hintConfig;
    }

    @Override
    public void close() {
        if (this.parent != null) {
            th.set(this.parent);
        } else {
            th.remove();
        }
    }

    public String toString() {
        String s = this.toShardingHintString();
        if (s.length() > 512) {
            s = s.substring(0, 512) + "...";
        }
        return s;
    }

    @SdkInternal
    public String toShardingHintString() {
        if (this.shardingHint == null) {
            String ss;
            String string = ss = this.batchSharding ? ":batch_sharding" : "";
            if (this.barrier) {
                this.shardingHint = prefix + this.hintTable + ss + suffix;
            } else {
                ArrayList<String> fields = new ArrayList<String>(this.cmap.size());
                for (List<HintCondition> cs : this.cmap.values()) {
                    for (HintCondition c : cs) {
                        fields.add(c.toJson());
                    }
                }
                this.shardingHint = prefix + this.hintTable + ss + ':' + JSON.toJSONString(fields) + suffix;
            }
        }
        return this.shardingHint;
    }

    @SdkInternal
    public static ShardingHintContext fromShardingHintString(String shardingHint) {
        if (!shardingHint.startsWith(prefix) || !shardingHint.endsWith(suffix)) {
            return null;
        }
        try {
            String content = shardingHint.substring(prefix.length(), shardingHint.length() - suffix.length());
            int p = content.indexOf(58);
            String hintTable = p == -1 ? content : content.substring(0, p);
            content = content.substring(p + 1);
            boolean shareBatchSharding = false;
            if (content.startsWith(batch_sharding)) {
                shareBatchSharding = true;
                content = content.substring(batch_sharding.length() + 1);
            }
            if (table_barrier.equals(hintTable)) {
                ShardingHintContext ctx = ShardingHintContext.createBarrier();
                ctx.setBatchShardingEnabled(shareBatchSharding);
                return ctx;
            }
            JSONArray array = JSON.parseArray((String)content);
            int n = array.size();
            HintCondition[] cs = new HintCondition[n];
            for (int i = 0; i < n; ++i) {
                cs[i] = HintCondition.fromJson(array.getString(i));
            }
            ShardingHintContext ctx = ShardingHintContext.create(hintTable, cs);
            ctx.setBatchShardingEnabled(shareBatchSharding);
            return ctx;
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap("Incorrect sharding hint: " + shardingHint, e);
        }
    }

    @Deprecated
    @SdkInternal
    public static final class ShardingHintCondition
    extends HintCondition {
        public ShardingHintCondition(String field, FilterType filterType, Object value) {
            super(field, filterType, value);
        }
    }
}

