/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.jdbc.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import kd.bos.xdb.AutoCloseSet;
import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.ParallelTag;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.eventbus.RequestContextInfo;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.mergeengine.ErrorClose;
import kd.bos.xdb.mergeengine.ExecutionContext;

public class XDBConnection {
    static final XDBConnection connection = new XDBConnection();
    private static final ConcurrentHashMap<String, Semaphore> globalParallelSizeMap = new ConcurrentHashMap(64);

    public static XDBConnection get() {
        return connection;
    }

    public static Semaphore getGlobalParallelSizeSemaphore() {
        String dbRoute = ExtContext.get().getDBRoute().toLowerCase();
        return XDBConnection.getGlobalParallelSizeSemaphore(dbRoute);
    }

    public static Semaphore getGlobalParallelSizeSemaphore(String dbRoute) {
        RequestContextInfo rc = RequestContextInfo.get();
        return globalParallelSizeMap.computeIfAbsent(rc.getTenantId() + '#' + rc.getAccountId() + '#' + dbRoute.toLowerCase(), key -> new Semaphore(XDBConfig.get().getGlobalParallelSize()));
    }

    public Connection requireConnection(AutoCloseSet autoCloseSet, boolean isForManager, String mainRoute, String curRoute) throws SQLException {
        ParallelConnectionHolder connectionHolder = ConnectionProvider.get().getConnectionHolder();
        Connection con = connectionHolder.requireConnection(isForManager, false, true, mainRoute, curRoute, null);
        if (autoCloseSet != null) {
            autoCloseSet.add(curRoute, con);
        }
        return con;
    }

    public Connection requireConnection(ParallelTag tag, boolean isForManager, AutoCloseSet autoCloseSet, boolean writtenInTX, String querySQL) throws SQLException {
        ParallelConnectionHolder connectionHolder = ConnectionProvider.get().getConnectionHolder();
        Connection con = connectionHolder.requireConnection(isForManager, true, writtenInTX, ExtContext.get().getDBRoute(), ExtContext.get().getDBRoute(), querySQL);
        if (autoCloseSet != null) {
            autoCloseSet.add(con);
        }
        if (tag != null && connectionHolder.isMainConnection(con)) {
            tag.tagSerialExcution();
        }
        return con;
    }

    public void releaseConnectionForQuery(Connection con) {
        if (con != null) {
            ConnectionProvider.get().getConnectionHolder().releaseForSharing(ExtContext.get().getDBRoute(), con);
        }
    }

    public Connection requireConnection(ExecutionContext executionContext, AutoCloseSet autoCloseSet) throws SQLException {
        ParallelConnectionHolder connectionHolder = executionContext.getConnectionHolder();
        String curRoute = executionContext.getForManagerRoute() != null ? executionContext.getForManagerRoute() : ExtContext.get().getDBRoute();
        Connection con = connectionHolder.requireConnection(executionContext.isForManager(), true, executionContext.isWrittenInTX(), ExtContext.get().getDBRoute(), curRoute, executionContext.getOriginalSQL());
        if (autoCloseSet != null) {
            autoCloseSet.add(curRoute, con);
        }
        return con;
    }

    public void releaseConnectionForQuery(Connection con, ExecutionContext executionContext) {
        if (con != null) {
            String curRoute = executionContext.getForManagerRoute() != null ? executionContext.getForManagerRoute() : ExtContext.get().getDBRoute();
            executionContext.getConnectionHolder().releaseForSharing(curRoute, con);
        }
    }

    public Connection requireConnection(ParallelTag tag, ExecutionContext executionContext, ErrorClose errorClose, String mainRoute, String curRoute) throws SQLException {
        ParallelConnectionHolder connectionHolder = executionContext.getConnectionHolder();
        Connection con = connectionHolder.requireConnection(executionContext.isForManager(), true, executionContext.isWrittenInTX(), mainRoute, curRoute, executionContext.getOriginalSQL());
        if (errorClose != null) {
            errorClose.add(curRoute, con);
        }
        if (tag != null && connectionHolder.isMainConnection(con)) {
            tag.tagSerialExcution();
        }
        return con;
    }

    public void releaseConnectionForQuery(String dbRoute, Connection con, ParallelConnectionHolder connectionHolder) {
        if (con != null) {
            connectionHolder.releaseForSharing(dbRoute, con);
        }
    }
}

