/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge;

import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.merge.WrapCloseResultSet;
import kd.bos.xdb.merge.distinct.DistinctMerger;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.groupby.GroupByMerger;
import kd.bos.xdb.merge.limit.LimitMerger;
import kd.bos.xdb.merge.orderby.OrderByMerger;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.MergedResultSet;
import kd.bos.xdb.merge.resultset.SkipResultSet;
import kd.bos.xdb.merge.resultset.StreamMergeSet;
import kd.bos.xdb.merge.union.UnionMerger;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.util.Pair;
import kd.bos.xdb.xpm.metrics.action.merge.MergeFeatureSpan;
import kd.bos.xdb.xpm.metrics.action.merge.MergeNoneSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public final class MergeManager {
    public static ResultSet union(ShardingConfigProvider scp, StatementInfo si, List<Pair<ShardingResult, ResultSet>> rss, SQLSelectStatement parentStmt, SelectFeature sf, SelectFeature rootSF, MetricsCollector mc) throws SQLException {
        MergeFeatureSpan mspan;
        long ts = System.currentTimeMillis();
        if (mc.isActionMetricEnabled()) {
            mspan = new MergeFeatureSpan(sf);
            mspan.addMergePath(UnionMerger.class.getSimpleName());
            mc.actionMetric().stat(mspan);
        } else {
            mspan = MergeFeatureSpan.blackHole();
        }
        MergeSet ms = new UnionMerger(rss, pair -> {
            ShardingResult sr = (ShardingResult)pair.getKey();
            StatementInfo subSI = sr.getStatementInfo();
            return MergeManager.merge(scp, subSI, null, new ResultSet[]{(ResultSet)pair.getValue()}, sr.getSelectFeature(), mc);
        }).merge(mspan);
        ms = MergeManager.doMerge(ms, scp, null, rootSF, mspan);
        if (mc.isPerformanceMetricEnabled()) {
            mc.performanceMetric().setMergeSpent(System.currentTimeMillis() - ts);
        }
        return new MergedResultSet(ms, ms.getMetaData());
    }

    public static ResultSet merge(ShardingConfigProvider scp, StatementInfo si, AutoCloseable onClose, ResultSet[] rss, SelectFeature sf, MetricsCollector mc) throws SQLException {
        ResultSet rs;
        long ts = System.currentTimeMillis();
        if (rss.length == 1) {
            if (mc.isPerformanceMetricEnabled() && mc.sqlFeature().isSharding()) {
                mc.actionMetric().stat(MergeNoneSpan.INSTANCE);
            }
            rs = rss[0];
            if (sf != null && sf.hasLimit()) {
                rs = new SkipResultSet(rs, sf.getOffset());
            }
        } else {
            MergeSet ms = new StreamMergeSet(rss);
            if (si != null && si.getStatementType() == StatementType.select) {
                MergeFeatureSpan mspan;
                if (mc.isPerformanceMetricEnabled()) {
                    mspan = new MergeFeatureSpan(sf);
                    mspan.addMergePath(StreamMergeSet.class.getSimpleName());
                    mc.actionMetric().stat(mspan);
                } else {
                    mspan = MergeFeatureSpan.blackHole();
                }
                ms = MergeManager.doMerge(ms, scp, si, sf, mspan);
            } else if (mc.isPerformanceMetricEnabled()) {
                mc.actionMetric().stat(MergeNoneSpan.INSTANCE);
            }
            rs = new MergedResultSet(ms, ms.getMetaData());
        }
        if (mc.isPerformanceMetricEnabled()) {
            mc.performanceMetric().setMergeSpent(System.currentTimeMillis() - ts);
        }
        try {
            return MergeManager.wrapCloseResultSet(rs, onClose);
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
    }

    private static MergeSet doMerge(MergeSet ms, ShardingConfigProvider scp, StatementInfo si, SelectFeature sf, MergeFeatureSpan mspan) {
        if (sf.hasGroupBy()) {
            ms = new GroupByMerger((StreamMergeSet)ms, sf, si, scp).merge(mspan);
        } else if (sf.hasAggregate()) {
            sf.setGroupByInfo(new GroupByInfo(sf.getSelectItems()));
            ms = new GroupByMerger((StreamMergeSet)ms, sf, si, scp).merge(mspan);
        }
        if (sf.hasOrderBy()) {
            ms = new OrderByMerger(ms, sf).merge(mspan);
        }
        if (sf.hasDistinct()) {
            ms = new DistinctMerger(ms, sf).merge(mspan);
        }
        if (sf.hasLimit()) {
            ms = new LimitMerger(ms, sf).merge(mspan);
        }
        return ms;
    }

    private static ResultSet wrapCloseResultSet(ResultSet rs, AutoCloseable onClose) throws Exception {
        return new WrapCloseResultSet(rs, onClose);
    }

    public static Integer findSelectItemIndexByName(List<SQLSelectItem> selectItems, String name) {
        int k = 0;
        for (SQLSelectItem item : selectItems) {
            String selectName = item.getExpr().toString().toLowerCase();
            if (selectName.equals(name)) {
                return k;
            }
            ++k;
        }
        return null;
    }
}

