/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.ProxyResultSet;

public class WrapCloseResultSet
extends ProxyResultSet {
    private final AutoCloseable onClose;
    private final boolean spaceAsEmptyString;
    private Map<Integer, String> spaceAsEmptyStringColumnMap;
    private static Set<Integer> explicitTypes = new HashSet<Integer>(7);

    public WrapCloseResultSet(ResultSet rs, AutoCloseable onClose) throws SQLException {
        this(rs, onClose, XDBConfig.get().isSpaceAsEmptyString());
    }

    public WrapCloseResultSet(ResultSet rs, AutoCloseable onClose, boolean spaceAsEmptyString) throws SQLException {
        super(rs);
        this.onClose = onClose;
        this.spaceAsEmptyString = spaceAsEmptyString;
        if (spaceAsEmptyString) {
            ResultSetMetaData md = rs.getMetaData();
            this.spaceAsEmptyStringColumnMap = new HashMap<Integer, String>();
            int n = md.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                int type = md.getColumnType(i);
                if (!explicitTypes.contains(type)) continue;
                this.spaceAsEmptyStringColumnMap.put(i, md.getColumnName(i).toLowerCase());
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.rs.close();
        if (this.onClose != null) {
            try {
                this.onClose.close();
            }
            catch (Exception e) {
                throw ExceptionUtil.as(SQLException.class, e);
            }
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.spaceAsEmptyString ? this.uncodeSpaceAsEmptyString(this.rs.getString(columnIndex)) : this.rs.getString(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.spaceAsEmptyString ? this.uncodeSpaceAsEmptyString(this.rs.getString(columnLabel)) : this.rs.getString(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Object value = this.rs.getObject(columnIndex);
        if (this.spaceAsEmptyString && (value == null || value instanceof String) && this.spaceAsEmptyStringColumnMap.containsKey(columnIndex)) {
            value = this.uncodeSpaceAsEmptyString((String)value);
        }
        return value;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Object value = this.rs.getObject(columnLabel);
        if (this.spaceAsEmptyString && (value == null || value instanceof String) && this.spaceAsEmptyStringColumnMap.containsValue(columnLabel.toLowerCase())) {
            value = this.uncodeSpaceAsEmptyString((String)value);
        }
        return value;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        Object value = this.rs.getObject(columnIndex, map);
        if (this.spaceAsEmptyString && (value == null || value instanceof String) && this.spaceAsEmptyStringColumnMap.containsKey(columnIndex)) {
            value = this.uncodeSpaceAsEmptyString((String)value);
        }
        return value;
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        Object value = this.rs.getObject(columnLabel, map);
        if (this.spaceAsEmptyString && (value == null || value instanceof String) && this.spaceAsEmptyStringColumnMap.containsValue(columnLabel.toLowerCase())) {
            value = this.uncodeSpaceAsEmptyString((String)value);
        }
        return value;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        Object value = this.rs.getObject(columnIndex, type);
        if (this.spaceAsEmptyString && (value == null || value instanceof String) && this.spaceAsEmptyStringColumnMap.containsKey(columnIndex)) {
            value = this.uncodeSpaceAsEmptyString((String)value);
        }
        return value;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        Object value = this.rs.getObject(columnLabel, type);
        if (this.spaceAsEmptyString && (value == null || value instanceof String) && this.spaceAsEmptyStringColumnMap.containsValue(columnLabel.toLowerCase())) {
            value = this.uncodeSpaceAsEmptyString((String)value);
        }
        return value;
    }

    private String uncodeSpaceAsEmptyString(String value) {
        if (value != null && value.length() == 1 && " ".equals(value)) {
            return "";
        }
        return value;
    }

    static {
        explicitTypes.addAll(Arrays.asList(1, 12, -1, -9, -16, 2005, 2011));
    }
}

