/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.feature;

import com.alibaba.druid.sql.ast.KSQLTop;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class MergeFeatureVisitor
extends MySqlASTVisitorAdapter {
    private SelectFeature sf = new SelectFeature();
    private SQLSelectQueryBlock unionFirstQueryBlock;
    private boolean resetTop = true;

    public MergeFeatureVisitor(SQLSelect sqlSelect) {
        this.resetTop = false;
        sqlSelect.accept((SQLASTVisitor)((Object)this));
    }

    public MergeFeatureVisitor(SQLSelectStatement stmt) {
        MetricsCollector.getCurrent().sqlFeature().setSelectFeature(this.sf);
        SQLSelectQuery query = stmt.getSelect().getQuery();
        if (query instanceof SQLSelectQueryBlock) {
            int distionOption = ((SQLSelectQueryBlock)query).getDistionOption();
            if (distionOption == 2) {
                this.sf.setDistinct();
            }
        } else if (query instanceof SQLUnionQuery) {
            this.sf.setUnion();
            this.unionFirstQueryBlock = ((SQLUnionQuery)query).getFirstQueryBlock();
        }
        stmt.accept((SQLASTVisitor)((Object)this));
    }

    public SelectFeature getSelectFeature() {
        return this.sf;
    }

    public boolean visit(SQLLimit x) {
        this.parseTopAndResetOffset(x.getRowCount(), x.getOffset());
        return super.visit(x);
    }

    public boolean visit(KSQLTop x) {
        this.parseTopAndResetOffset(x.getRowCount(), x.getOffset());
        return super.visit(x);
    }

    private void parseTopAndResetOffset(SQLExpr rowCount, SQLExpr offset) {
        if (offset == null) {
            this.sf.setOffset(0);
            this.sf.setLength(Integer.parseInt(rowCount.toString()));
        } else {
            this.sf.setOffset(Integer.parseInt(offset.toString()));
            this.sf.setLength(Integer.parseInt(rowCount.toString()));
            if (this.resetTop) {
                ((SQLIntegerExpr)offset).setNumber((Number)0);
                ((SQLIntegerExpr)rowCount).setNumber((Number)(this.sf.getOffset() + this.sf.getLength()));
            }
        }
    }

    public boolean visit(SQLOrderBy x) {
        List items = x.getItems();
        this.sf.setOrderByInfo(new OrderByInfo(items, this.sf.getSelectItems()));
        return super.visit(x);
    }

    public boolean visit(SQLSelectGroupByClause x) {
        this.sf.setGroupByInfo(new GroupByInfo(x, this.sf.getSelectItems()));
        return super.visit(x);
    }

    public boolean visit(SQLGroupingSetExpr x) {
        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"MergeFeatureVisitor_0", (String)"\u8bf7\u589e\u52a0\u5bf9\u8868\u8fbe\u5f0f\u7684\u5904\u7406:{0}\u3002", (Object[])new Object[]{x}));
    }

    public boolean visit(SQLAggregateExpr x) {
        if (!(x.getParent() instanceof SQLSelectItem)) {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"MergeFeatureVisitor_1", (String)"\u805a\u5408\u5217\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f:{0}\u3002", (Object[])new Object[]{x.getParent()}));
        }
        if ("AVG".equals(x.getMethodName().toUpperCase())) {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"MergeFeatureVisitor_2", (String)"\u5206\u7247\u4e0d\u652f\u6301\u805a\u5408\u51fd\u6570:{0}\u3002", (Object[])new Object[]{x}));
        }
        if (!this.sf.hasAggregate()) {
            this.sf.setHasAggregate();
        }
        return super.visit(x);
    }

    public boolean visit(SQLSelectItem x) {
        if (this.sf.isUnion()) {
            SQLObject parent = x.getParent();
            while (parent != this.unionFirstQueryBlock) {
                if ((parent = parent.getParent()) != null) continue;
                return true;
            }
        }
        this.sf.getSelectItems().add(x);
        return super.visit(x);
    }
}

