/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.groupby;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.groupby.AggregateFunction;
import kd.bos.xdb.merge.resultset.ObjectConverter;

public class AggregateFunctionFactory {
    private static final Map<String, AggregateFunction> funcMap = new HashMap<String, AggregateFunction>();

    public static AggregateFunction getAggregateFunction(String methodName) {
        AggregateFunction func = funcMap.get(methodName.toUpperCase());
        if (func == null) {
            throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AggregateFunctionFactory_0", (String)"\u4e0d\u652f\u6301\u805a\u5408\u51fd\u6570:{0}", (Object[])new Object[]{methodName}));
        }
        return func;
    }

    static {
        funcMap.put("SUM", new SUM());
        funcMap.put("MAX", new MAX());
        funcMap.put("MIN", new MIN());
        funcMap.put("COUNT", new COUNT());
    }

    private static class COUNT
    implements AggregateFunction {
        private COUNT() {
        }

        @Override
        public Object agg(Object obj1, Object obj2, Class<?> type) {
            return ((Number)obj1).intValue() + ((Number)obj2).intValue();
        }
    }

    private static class MIN
    implements AggregateFunction {
        private MIN() {
        }

        @Override
        public Object agg(Object obj1, Object obj2, Class<?> type) {
            if (((Comparable)obj1).compareTo(obj2) <= 0) {
                return obj1;
            }
            return obj2;
        }
    }

    private static class MAX
    implements AggregateFunction {
        private MAX() {
        }

        @Override
        public Object agg(Object obj1, Object obj2, Class<?> type) {
            if (((Comparable)obj1).compareTo(obj2) < 0) {
                return obj2;
            }
            return obj1;
        }
    }

    private static class SUM
    implements AggregateFunction {
        private SUM() {
        }

        @Override
        public Object agg(Object obj1, Object obj2, Class<?> type) {
            if (type == Integer.TYPE || type == Integer.class) {
                return ((Number)obj1).intValue() + ((Number)obj2).intValue();
            }
            if (type == Long.TYPE || type == Long.class) {
                return ((Number)obj1).longValue() + ((Number)obj2).longValue();
            }
            BigDecimal bd1 = BigDecimal.valueOf(((Number)obj1).doubleValue());
            BigDecimal bd2 = BigDecimal.valueOf(((Number)obj2).doubleValue());
            return ObjectConverter.convert(bd1.add(bd2), type);
        }
    }
}

