/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.orderby;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.MergeManager;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.resultset.memory.Row;

public final class OrderByComparator
implements Comparator<Row> {
    private final int size;
    private final int[] indexies;
    private final boolean[] asc;
    private final OrderByInfo obi;

    public OrderByComparator(OrderByInfo obi, Map<String, Integer> colIndexMap) {
        this.obi = obi;
        List<OrderByInfo.OrderByItem> items = obi.getOrderByItems();
        this.size = items.size();
        this.indexies = new int[this.size];
        this.asc = new boolean[this.size];
        int i = 0;
        for (OrderByInfo.OrderByItem item : items) {
            String orderByName = item.getField();
            Integer index = colIndexMap.get(orderByName);
            if (index == null) {
                index = MergeManager.findSelectItemIndexByName(obi.getSelectItems(), orderByName);
            }
            if (index == null) {
                throw new IllegalArgumentException(BosRes.get((String)"bos-xdb", (String)"OrderByComparator_0", (String)"\u5408\u5e76\u5206\u7247,order by\u7684\u8868\u8fbe\u5f0f\u5fc5\u987b\u51fa\u73b0\u5728select\u4e2d:{0}", (Object[])new Object[]{item.getField()}));
            }
            this.indexies[i] = index;
            this.asc[i] = item.isAsc();
            ++i;
        }
    }

    public OrderByInfo getOrderByInfo() {
        return this.obi;
    }

    @Override
    public int compare(Row o1, Row o2) {
        for (int i = 0; i < this.size; ++i) {
            int ret;
            Comparable c1 = (Comparable)o1.get(this.indexies[i]);
            Comparable c2 = (Comparable)o2.get(this.indexies[i]);
            if (c1 == null && c2 == null || (ret = c1 == null ? -1 : (c2 == null ? 1 : c1.compareTo(c2))) == 0) continue;
            return this.asc[i] ? ret : 0 - ret;
        }
        return 0;
    }
}

