/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.orderby;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.orderby.OrderByComparator;
import kd.bos.xdb.merge.orderby.ReduceOrderByColumnResultSetMetaData;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.merge.resultset.StreamMergeSet;
import kd.bos.xdb.merge.resultset.memory.Row;

public final class OrderByStreamMergeSet
implements MergeSet {
    private StreamMergeSet ms;
    private ResultSetMetaData md;
    private int cols;
    private int rsCount;
    private boolean[] hasNext;
    private ResultSet[] rss;
    private Map<String, Integer> colIndexMap = new HashMap<String, Integer>();
    private OrderByComparator comparator;
    private Map<Integer, Row> rsFirstRowMap;
    private LinkedList<Row> orderedRows;
    private Row curRow;

    public OrderByStreamMergeSet(StreamMergeSet ms, OrderByInfo obi) {
        this.rss = ms.getOriginalResultSets();
        this.rsCount = this.rss.length;
        this.rsFirstRowMap = new HashMap<Integer, Row>((int)((double)this.rsCount / 0.75));
        this.orderedRows = new LinkedList();
        this.hasNext = new boolean[this.rsCount];
        Arrays.fill(this.hasNext, true);
        try {
            this.md = ms.getMetaData();
            this.cols = this.md.getColumnCount();
            for (int i = 0; i < this.cols; ++i) {
                this.colIndexMap.put(this.md.getColumnName(i + 1).toLowerCase(), i);
            }
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        this.comparator = new OrderByComparator(obi, this.colIndexMap);
        this.ms = ms;
        if (obi.isResetSelect()) {
            this.md = new ReduceOrderByColumnResultSetMetaData(this.md, obi.getOriginalSelectColumnCount());
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (this.curRow != null) {
            this.rsFirstRowMap.remove(this.curRow.getTag());
            this.orderedRows.removeFirst();
            this.curRow = null;
        }
        for (int i = 0; i < this.rsCount; ++i) {
            Row or;
            if (!this.hasNext[i] || this.rsFirstRowMap.containsKey(i)) continue;
            Row row = this.nextRow(this.rss[i], i);
            if (row == null) {
                this.hasNext[i] = false;
                continue;
            }
            this.rsFirstRowMap.put(i, row);
            int insertIndex = 0;
            Iterator iterator = this.orderedRows.iterator();
            while (iterator.hasNext() && this.comparator.compare(row, or = (Row)iterator.next()) >= 0) {
                ++insertIndex;
            }
            this.orderedRows.add(insertIndex, row);
        }
        if (this.rsFirstRowMap.isEmpty()) {
            return false;
        }
        this.curRow = this.orderedRows.peekFirst();
        return true;
    }

    private Row nextRow(ResultSet rs, int rsIndex) {
        try {
            if (rs.next()) {
                Row row = new Row(this.cols, rsIndex);
                for (int i = 0; i < this.cols; ++i) {
                    row.set(i, rs.getObject(i + 1));
                }
                row.finishSet();
                return row;
            }
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
        return null;
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.curRow.get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.curRow.get(this.colIndexMap.get(columnName.toLowerCase())), type);
    }

    @Override
    public void close() throws SQLException {
        if (this.ms != null) {
            this.ms.close();
            this.ms = null;
            this.md = null;
            this.curRow = null;
            this.rsFirstRowMap = null;
            this.orderedRows = null;
            this.hasNext = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.md;
    }
}

