/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.orderby.greedystream;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.orderby.OrderByComparator;
import kd.bos.xdb.merge.orderby.ReduceOrderByColumnResultSetMetaData;
import kd.bos.xdb.merge.orderby.greedystream.AbstractOrderByStream;
import kd.bos.xdb.merge.orderby.greedystream.EmptyStream;
import kd.bos.xdb.merge.orderby.greedystream.MultiStream;
import kd.bos.xdb.merge.orderby.greedystream.SingleStream;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.merge.resultset.StreamMergeSet;
import kd.bos.xdb.merge.resultset.memory.Row;

public final class OrderByMultiStreamMergeSet
implements MergeSet {
    private boolean closed = false;
    private ResultSetMetaData md;
    private final Map<String, Integer> colIndexMap = new HashMap<String, Integer>();
    private final Comparator<Row> comparator;
    private final AbstractOrderByStream obs;
    private final ResultSet[] rss;

    public OrderByMultiStreamMergeSet(StreamMergeSet ms, OrderByInfo obi) {
        this.rss = ms.getOriginalResultSets();
        try {
            this.md = ms.getMetaData();
            int cols = this.md.getColumnCount();
            for (int i = 0; i < cols; ++i) {
                this.colIndexMap.put(this.md.getColumnName(i + 1).toLowerCase(), i);
            }
            this.comparator = new OrderByComparator(obi, this.colIndexMap);
            if (obi.isResetSelect()) {
                this.md = new ReduceOrderByColumnResultSetMetaData(this.md, obi.getOriginalSelectColumnCount());
            }
            int batchSize = this.rss.length < 10 ? 1000 : (this.rss.length < 100 ? 500 : Math.max(50, 10000 / this.rss.length));
            ArrayList<SingleStream> sortedSS = new ArrayList<SingleStream>(this.rss.length);
            for (int i = 0; i < this.rss.length; ++i) {
                SingleStream ss = new SingleStream(this.rss[i], cols, batchSize);
                ss.fetch(1);
                if (ss.peekRows().isEmpty()) {
                    ss.close();
                    continue;
                }
                sortedSS.add(ss);
            }
            if (sortedSS.isEmpty()) {
                this.obs = EmptyStream.instance;
            } else if (sortedSS.size() == 1) {
                this.obs = (AbstractOrderByStream)sortedSS.get(0);
            } else {
                Collections.sort(sortedSS, new Comparator<SingleStream>(){

                    @Override
                    public int compare(SingleStream o1, SingleStream o2) {
                        return OrderByMultiStreamMergeSet.this.comparator.compare(o1.peekRows().getFirst(), o2.peekRows().getFirst());
                    }
                });
                this.obs = new MultiStream(sortedSS, this.comparator, batchSize);
            }
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.obs.next();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.obs.curRow.get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.obs.curRow.get(this.colIndexMap.get(columnName.toLowerCase())), type);
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.obs.close();
            for (ResultSet rs : this.rss) {
                rs.close();
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.md;
    }
}

