/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.orderby.greedystream;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.xdb.merge.orderby.greedystream.AbstractOrderByStream;
import kd.bos.xdb.merge.resultset.memory.Row;
import kd.bos.xdb.util.RingList;

final class SingleStream
extends AbstractOrderByStream {
    private final int cols;
    private final ResultSet rs;
    private RingList<Row> rows;
    private boolean closed = false;
    private boolean noMoreData = false;

    SingleStream(ResultSet rs, int cols, int maxFetchSize) throws SQLException {
        this.rs = rs;
        this.cols = cols;
        this.rows = new RingList(maxFetchSize);
    }

    void fetch(int size) throws SQLException {
        if (!this.closed && !this.noMoreData) {
            int fetchSize = size - this.rows.size();
            for (int i = 0; i < fetchSize && this.rs.next(); ++i) {
                this.rows.add(this.nextRow());
            }
            if (this.rows.size() < size) {
                this.noMoreData = true;
            }
        }
    }

    @Override
    boolean next() throws SQLException {
        if (!this.rows.isEmpty()) {
            this.curRow = this.rows.removeFirst();
            return true;
        }
        if (this.rs.next()) {
            this.curRow = this.nextRow();
            return true;
        }
        this.close();
        return false;
    }

    RingList<Row> peekRows() {
        return this.rows;
    }

    @Override
    void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.curRow = null;
        }
    }

    boolean endOfStream() {
        return (this.closed || this.noMoreData) && this.rows.isEmpty();
    }

    private Row nextRow() throws SQLException {
        Row row = new Row(this.cols);
        for (int i = 0; i < this.cols; ++i) {
            row.set(i, this.rs.getObject(i + 1));
        }
        return row;
    }
}

