/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset.dataset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.merge.resultset.dataset.DataSetRowSet;

public final class DataSetMergeSet
implements MergeSet {
    private DataSetRowSet dataSetRowSet;

    public DataSetMergeSet(MergeSet ms) {
        try {
            this.dataSetRowSet = new DataSetRowSet(ms);
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.dataSetRowSet.next();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.dataSetRowSet.getRow().get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        int columnIndex = this.dataSetRowSet.getColumnIndexMap().get(columnName.toLowerCase());
        return this.get(columnIndex, type);
    }

    @Override
    public void close() throws SQLException {
        if (this.dataSetRowSet != null) {
            this.dataSetRowSet.close();
            this.dataSetRowSet = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.dataSetRowSet.getMetaData();
    }

    public void groupBy(GroupByInfo gbi) {
        this.dataSetRowSet.groupBy(gbi);
    }

    public void distinct() {
        this.dataSetRowSet.distinct();
    }

    public void orderBy(OrderByInfo obi) {
        this.dataSetRowSet.orderBy(obi);
    }
}

