/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset.dataset;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.merge.MergeManager;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.dataset.MergSetIterator;

public class DataSetRowSet {
    private ResultSetMetaData md;
    private DataSet ds;
    private Row curRow;
    private Map<String, Integer> colIndexMap = new HashMap<String, Integer>(16);
    private Map<String, String> colAlaisMap = new HashMap<String, String>(16);
    private Map<Integer, String> indexColMap = new HashMap<Integer, String>(16);
    private static final String ALAIS_PREFIX = "myalais_";

    public DataSetRowSet(MergeSet ms) throws SQLException {
        this(ms, -1);
    }

    public DataSetRowSet(MergeSet ms, int fetchSize) throws SQLException {
        this.md = ms.getMetaData();
        String algoKey = this.getClass().toString();
        RowMeta rowMeta = this.getRowMeta();
        for (int i = 0; i < this.md.getColumnCount(); ++i) {
            this.colIndexMap.put(this.md.getColumnName(i + 1).toLowerCase(), i);
            this.indexColMap.put(i, this.md.getColumnName(i + 1).toLowerCase());
        }
        MergSetIterator iterator = new MergSetIterator(ms);
        this.ds = Algo.create((String)algoKey).createDataSet((Iterator)iterator, rowMeta);
        if (fetchSize > 0) {
            this.ds = this.ds.range(0, fetchSize);
        }
    }

    public DataSetRowSet(ResultSet rs) throws SQLException {
        this(rs, -1);
    }

    public DataSetRowSet(ResultSet rs, int fetchSize) throws SQLException {
        this.md = rs.getMetaData();
        String algoKey = this.getClass().toString();
        RowMeta rowMeta = this.getRowMeta();
        for (int i = 0; i < this.md.getColumnCount(); ++i) {
            this.colIndexMap.put(this.md.getColumnName(i + 1).toLowerCase(), i);
            this.indexColMap.put(i, this.md.getColumnName(i + 1).toLowerCase());
        }
        this.ds = Algo.create((String)algoKey).createDataSet(rs, rowMeta);
        if (fetchSize > 0) {
            this.ds = this.ds.range(0, fetchSize);
        }
    }

    public Map<String, Integer> getColumnIndexMap() {
        return this.colIndexMap;
    }

    private RowMeta getRowMeta() {
        try {
            Field[] fields = new Field[this.md.getColumnCount()];
            for (int i = 0; i < fields.length; ++i) {
                int sqlType = this.md.getColumnType(i + 1);
                String name = this.md.getColumnName(i + 1).toLowerCase();
                String alais = ALAIS_PREFIX + i;
                this.colAlaisMap.put(name, ALAIS_PREFIX + i);
                fields[i] = new Field(alais, DataType.fromSqlType((int)sqlType), true);
            }
            return new RowMeta(fields);
        }
        catch (SQLException e) {
            throw new AlgoException((Throwable)e);
        }
    }

    public boolean next() {
        boolean hasNest = this.ds.hasNext();
        if (hasNest) {
            this.curRow = this.ds.next();
        }
        return hasNest;
    }

    public Row getRow() {
        return this.curRow;
    }

    public void close() {
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public ResultSetMetaData getMetaData() {
        return this.md;
    }

    public void distinct() {
        this.ds = this.ds.distinct();
    }

    public void groupBy(GroupByInfo gbi) {
        String[] selectFields = this.ds.getRowMeta().getFieldNames();
        String[] groupByFields = this.getGropByFields(gbi);
        GroupbyDataSet gds = this.ds.groupBy(groupByFields);
        int fieldIndex = 0;
        for (SQLSelectItem selectItem : gbi.getSelectItems()) {
            SQLExpr expr = selectItem.getExpr();
            if (expr instanceof SQLAggregateExpr) {
                String aggFunc = ((SQLAggregateExpr)expr).getMethodName().toUpperCase();
                String fieldAlias = ALAIS_PREFIX + fieldIndex;
                switch (aggFunc) {
                    case "SUM": 
                    case "COUNT": {
                        gds = gds.sum(fieldAlias);
                        break;
                    }
                    case "MAX": {
                        gds = gds.max(fieldAlias);
                        break;
                    }
                    case "MIN": {
                        gds = gds.min(fieldAlias);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"AggregateFunctionFactory_0", (String)"\u4e0d\u652f\u6301\u805a\u5408\u51fd\u6570:{0}", (Object[])new Object[]{aggFunc}));
                    }
                }
            }
            ++fieldIndex;
        }
        this.ds = gds.finish();
        this.ds = this.ds.select(selectFields);
    }

    public void orderBy(OrderByInfo obi) {
        String[] orderByFields = this.getOrderByFields(obi);
        this.ds = this.ds.orderBy(orderByFields);
    }

    private String[] getOrderByFields(OrderByInfo obi) {
        List<OrderByInfo.OrderByItem> items = obi.getOrderByItems();
        String[] orderByFields = new String[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            String colName;
            Integer index;
            String orderField = this.colAlaisMap.get(items.get(i).getField());
            if (orderField == null && (index = MergeManager.findSelectItemIndexByName(obi.getSelectItems(), items.get(i).getField())) != null && (colName = this.indexColMap.get(index)) != null) {
                orderField = this.colAlaisMap.get(colName) + (items.get(i).isAsc() ? " asc" : " desc");
            }
            if (orderField == null) {
                throw new IllegalArgumentException("Select fields should include order by items.");
            }
            orderByFields[i] = orderField + (items.get(i).isAsc() ? " asc" : " desc");
        }
        return orderByFields;
    }

    private String[] getGropByFields(GroupByInfo gbi) {
        List<GroupByInfo.GroupByItem> groupByItems = gbi.getGroupByItems();
        int size = groupByItems.size();
        String[] groupByFields = new String[size];
        for (int i = 0; i < size; ++i) {
            String colName;
            Integer index;
            groupByFields[i] = this.colAlaisMap.get(groupByItems.get(i).getField());
            if (groupByFields[i] == null && (index = MergeManager.findSelectItemIndexByName(gbi.getSelectItems(), groupByItems.get(i).getField())) != null && (colName = this.indexColMap.get(index)) != null) {
                groupByFields[i] = this.colAlaisMap.get(colName);
            }
            if (groupByFields[i] != null) continue;
            throw new IllegalArgumentException("Select fields should include group by items.");
        }
        return groupByFields;
    }
}

