/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset.dataset;

import java.sql.SQLException;
import java.util.Iterator;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.resultset.MergeSet;

public final class MergSetIterator
implements Iterator<Object[]> {
    private MergeSet ms;
    private final int count;

    public MergSetIterator(MergeSet ms) {
        this.ms = ms;
        try {
            this.count = ms.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.ms.next();
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public Object[] next() {
        try {
            Object[] values = new Object[this.count];
            for (int i = 0; i < this.count; ++i) {
                values[i] = this.ms.get(i, Object.class);
            }
            return values;
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

