/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset.fetched;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.merge.resultset.dataset.DataSetRowSet;

public final class FetchedMergeSet
implements MergeSet {
    private boolean useFetched;
    private DataSetRowSet rowSet;
    private ResultSet rs;

    public FetchedMergeSet(ResultSet rs, int fetchSize) throws SQLException {
        if (fetchSize > 0) {
            this.rowSet = new DataSetRowSet(rs, fetchSize);
            this.useFetched = true;
        } else {
            this.useFetched = false;
        }
        this.rs = rs;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.useFetched) {
            if (this.rowSet.next()) {
                return true;
            }
            this.useFetched = false;
        }
        return this.rs.next();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        if (this.useFetched) {
            return ObjectConverter.convert(this.rowSet.getRow().get(columnIndex), type);
        }
        return ObjectConverter.convert(this.rs.getObject(columnIndex + 1), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        if (this.useFetched) {
            int columnIndex = this.rowSet.getColumnIndexMap().get(columnName);
            return ObjectConverter.convert(this.rowSet.getRow().get(columnIndex), type);
        }
        return ObjectConverter.convert(this.rs.getObject(columnName), type);
    }

    @Override
    public void close() throws SQLException {
        if (this.rs != null) {
            if (this.rowSet != null) {
                this.rowSet.close();
            }
            this.rs.close();
            this.rowSet = null;
            this.rs = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rs.getMetaData();
    }
}

