/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset.memory;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.OrderByInfo;
import kd.bos.xdb.merge.groupby.Aggregator;
import kd.bos.xdb.merge.orderby.OrderByComparator;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.merge.resultset.memory.Row;
import kd.bos.xdb.merge.resultset.memory.RowSet;

public final class MemoryMergeSet
implements MergeSet {
    private RowSet rowSet;

    public MemoryMergeSet(MergeSet ms) {
        try {
            this.rowSet = new RowSet(ms);
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        return this.rowSet.next();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.rowSet.getRow().get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.rowSet.getRow().get(this.rowSet.getColumnIndex(columnName)), type);
    }

    @Override
    public void close() throws SQLException {
        if (this.rowSet != null) {
            this.rowSet.close();
            this.rowSet = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowSet.getMetaData();
    }

    public void groupBy(GroupByInfo gbi) throws SQLException {
        Aggregator agg = new Aggregator(gbi, this.rowSet.getColumnIndexMap(), this.rowSet.getMetaData());
        List<Row> list = agg.agg(this.rowSet.getRows());
        this.rowSet.setInnerData(list);
    }

    public void OrderBy(OrderByInfo obi) {
        this.rowSet.orderBy(new OrderByComparator(obi, this.rowSet.getColumnIndexMap()));
    }
}

