/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset.memory;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.orderby.OrderByComparator;
import kd.bos.xdb.merge.orderby.ReduceOrderByColumnResultSetMetaData;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.memory.Row;

public class RowSet {
    private LinkedList<Row> rows = new LinkedList();
    private Map<String, Integer> colIndexMap = new HashMap<String, Integer>(16);
    private AutoCloseable xset;
    private ResultSetMetaData md;
    private Row cur;

    public RowSet(MergeSet ms) throws SQLException {
        this(ms, -1);
    }

    public RowSet(MergeSet ms, int fetchSize) throws SQLException {
        this.xset = ms;
        this.md = ms.getMetaData();
        int cols = this.md.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.colIndexMap.put(this.md.getColumnName(i + 1).toLowerCase(), i);
        }
        boolean limit = fetchSize > 0;
        int n = 0;
        while (ms.next()) {
            Row row = new Row(cols);
            for (int i = 0; i < cols; ++i) {
                row.set(i, ms.get(i, Object.class));
            }
            row.finishSet();
            this.rows.add(row);
            if (!limit || ++n != fetchSize) continue;
            break;
        }
    }

    public RowSet(ResultSet rs) throws SQLException {
        this(rs, -1);
    }

    public RowSet(ResultSet rs, int fetchSize) throws SQLException {
        this.xset = rs;
        this.md = rs.getMetaData();
        int cols = this.md.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.colIndexMap.put(this.md.getColumnName(i + 1).toLowerCase(), i);
        }
        boolean limit = fetchSize > 0;
        int n = 0;
        while (rs.next()) {
            Row row = new Row(cols);
            for (int i = 0; i < cols; ++i) {
                row.set(i, rs.getObject(i + 1));
            }
            row.finishSet();
            this.rows.add(row);
            if (!limit || ++n != fetchSize) continue;
            break;
        }
    }

    List<Row> getRows() {
        return this.rows;
    }

    public boolean next() {
        if (this.rows.isEmpty()) {
            return false;
        }
        this.cur = this.rows.removeFirst();
        return true;
    }

    public Row getRow() {
        return this.cur;
    }

    public void close() throws SQLException {
        if (this.xset != null) {
            try {
                this.xset.close();
            }
            catch (Exception e) {
                throw ExceptionUtil.as(SQLException.class, e);
            }
            this.xset = null;
            this.rows = null;
        }
    }

    public int getColumnIndex(String columnName) {
        return this.colIndexMap.get(columnName.toLowerCase());
    }

    public ResultSetMetaData getMetaData() {
        return this.md;
    }

    public Map<String, Integer> getColumnIndexMap() {
        return this.colIndexMap;
    }

    void setInnerData(List<Row> rows) {
        this.rows = rows instanceof LinkedList ? (LinkedList<Object>)rows : new LinkedList<Row>(rows);
    }

    void orderBy(OrderByComparator obc) {
        Collections.sort(this.rows, obc);
        if (obc.getOrderByInfo().isResetSelect()) {
            int originalCount = obc.getOrderByInfo().getOriginalSelectColumnCount();
            if (this.colIndexMap.size() > originalCount) {
                int n = this.colIndexMap.size();
                for (int i = originalCount; i < n; ++i) {
                    String key = null;
                    for (Map.Entry<String, Integer> entry : this.colIndexMap.entrySet()) {
                        if (entry.getValue() != i) continue;
                        key = entry.getKey();
                        break;
                    }
                    if (key == null) continue;
                    this.colIndexMap.remove(key);
                }
                this.md = new ReduceOrderByColumnResultSetMetaData(this.md, originalCount);
            }
        }
    }
}

