/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine;

import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.mergeengine.MergeEngine;
import kd.bos.xdb.mergeengine.distinct.DistinctMergeEngineImpl;
import kd.bos.xdb.mergeengine.groupby.GroupByMergeEngineImpl;
import kd.bos.xdb.mergeengine.iterator.IteratorMergeEngineImpl;
import kd.bos.xdb.mergeengine.orderby.OrderByMergeEngineImpl;
import kd.bos.xdb.mergeengine.single.SingleMergeEngineImpl;
import kd.bos.xdb.mergeengine.union.UnionMergeEngineImpl;

public class MergeEngineFactory {
    private static final SingleMergeEngineImpl singleMergeEngine = new SingleMergeEngineImpl();
    private static final IteratorMergeEngineImpl iteratorMergeEngine = new IteratorMergeEngineImpl();
    private static final DistinctMergeEngineImpl distinctMergeEngine = new DistinctMergeEngineImpl();
    private static final GroupByMergeEngineImpl groupByMergeEngine = new GroupByMergeEngineImpl();
    private static final OrderByMergeEngineImpl orderByMergeEngine = new OrderByMergeEngineImpl();
    private static final UnionMergeEngineImpl unionMergeEngine = new UnionMergeEngineImpl();

    public static MergeEngine get(ShardingResult shardingResult) {
        if (shardingResult.withUnion()) {
            return unionMergeEngine;
        }
        SelectFeature selectFeature = shardingResult.getSelectFeature();
        if (selectFeature != null && shardingResult.getSQLInfos()[0].isShardingSQL()) {
            if (shardingResult.getSQLInfos().length > 1) {
                if (selectFeature.hasGroupBy()) {
                    return groupByMergeEngine;
                }
                if (selectFeature.hasAggregate()) {
                    selectFeature.setGroupByInfo(new GroupByInfo(selectFeature.getSelectItems()));
                    selectFeature.setGroupbyAndOrderbySame();
                    return groupByMergeEngine;
                }
                if (selectFeature.hasDistinct()) {
                    return distinctMergeEngine;
                }
                if (selectFeature.hasOrderBy()) {
                    return orderByMergeEngine;
                }
            }
            return iteratorMergeEngine;
        }
        return singleMergeEngine;
    }
}

