/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.groupby.segmerge;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.dataset.store.Store;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.orderby.ReduceOrderByColumnResultSetMetaData;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.mergeengine.groupby.segmerge.ResultSetsGroupBy;
import kd.bos.xdb.mergeengine.groupby.segmerge.StoresGroupBy;
import kd.bos.xdb.mergeengine.orderby.segmerge.AbstractSegMergeSet;
import kd.bos.xdb.mergeengine.orderby.segmerge.SegMergeStoreBuilder;
import kd.bos.xdb.mergeengine.orderby.segmerge.SegMergeThreadPools;
import kd.bos.xdb.mergeengine.orderby.segmerge.SetsOrderBy;
import kd.bos.xdb.mergeengine.resultset.ExecutionLazyResultSet;

public class GroupbyAndOrderbySameMergeSet
extends AbstractSegMergeSet {
    private boolean prepare = false;
    private Object[] curRow;

    public GroupbyAndOrderbySameMergeSet(ExecutionLazyResultSet executionLazyResultSet, SelectFeature sf) throws SQLException {
        this.executionLazyResultSet = executionLazyResultSet;
        this.sf = sf;
        this.init();
    }

    private void init() throws SQLException {
        if (this.executionLazyResultSet.getSqlsLength() <= this.streamSize) {
            this.executionLazyResultSet.setStream(true);
        }
        this.rowMeta = this.getRowMeta();
        this.flushMetaNameIndex(this.executionLazyResultSet.getResultSet());
        if (this.sf.getOrderByInfo() != null) {
            this.sf.getOrderByInfo().flushOrderByItemIndex(this.colMetaNameIndexMap, this.colExprNameIndexMap);
            if (this.sf.getOrderByInfo().isResetSelect()) {
                this.md = new ReduceOrderByColumnResultSetMetaData(this.executionLazyResultSet.getResultSet().getMetaData(), this.sf.getOrderByInfo().getOriginalSelectColumnCount());
            }
        }
        if (!this.sf.isGroupbyAndOrderbySame()) {
            this.sf.getOriginalOrderByInfo().flushOrderByItemIndex(this.colMetaNameIndexMap, this.colExprNameIndexMap);
        }
        if (this.executionLazyResultSet.getSqlsLength() <= this.streamSize) {
            this.setsOrderBy = new ResultSetsGroupBy(this.executionLazyResultSet.getResultSetSet(), this.sf);
        } else {
            boolean oracleSeries;
            int segCnt = this.executionLazyResultSet.getSqlsLength() / this.perSegSize + (this.executionLazyResultSet.getSqlsLength() % this.perSegSize == 0 ? 0 : 1);
            DBType dbType = ExtContext.get().getDBType();
            boolean bl = oracleSeries = dbType == DBType.oracle || dbType == DBType.dm || dbType == DBType.yasdb || dbType == DBType.oceanbase_oracle || dbType == DBType.hana;
            if ((this.sf.getOrderByInfo() == null || !this.sf.getOrderByInfo().isResetSelect()) && oracleSeries) {
                this.md = this.executionLazyResultSet.getResultSet().getMetaData();
                this.oracleSeriesSegMerge = true;
            }
            if (segCnt > this.perStoreSize) {
                Future<Store[]> future = SegMergeThreadPools.submit(() -> {
                    ArrayList<Store> retList = new ArrayList<Store>(segCnt / this.perStoreSize + (segCnt % this.perStoreSize == 0 ? 0 : 1));
                    ArrayList<Store> bufferList = new ArrayList<Store>(this.perStoreSize);
                    int bufferCnt = 0;
                    block2: while (true) {
                        try {
                            while (true) {
                                Store store;
                                if ((store = (Store)this.storeQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) {
                                    continue;
                                }
                                if (store == EOF_STORE) {
                                    if (bufferList.size() <= 0) break block2;
                                    retList.add(new SegMergeStoreBuilder(new StoresGroupBy(bufferList.toArray(new Store[bufferList.size()]), this.sf), this.rowMeta, this.sf).build());
                                    bufferList.clear();
                                    bufferCnt = 0;
                                    break block2;
                                }
                                bufferList.add(store);
                                if (++bufferCnt != this.perStoreSize) continue;
                                retList.add(new SegMergeStoreBuilder(new StoresGroupBy(bufferList.toArray(new Store[bufferList.size()]), this.sf), this.rowMeta, this.sf).build());
                                bufferList.clear();
                                bufferCnt = 0;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    return retList.toArray(new Store[retList.size()]);
                });
                for (int i = 0; i < segCnt; ++i) {
                    this.storeQueue.add(new SegMergeStoreBuilder(new ResultSetsGroupBy(this.executionLazyResultSet.getResultSetSet(this.perSegSize), this.sf), this.rowMeta, this.sf).build());
                }
                this.storeQueue.add(EOF_STORE);
                try {
                    Store[] stores = future.get();
                    this.setsOrderBy = new StoresGroupBy(this.merge(stores), this.sf);
                }
                catch (Exception e) {
                    throw ExceptionUtil.as(SQLException.class, e);
                }
            } else {
                Store[] stores = new Store[segCnt];
                for (int i = 0; i < segCnt; ++i) {
                    stores[i] = new SegMergeStoreBuilder(new ResultSetsGroupBy(this.executionLazyResultSet.getResultSetSet(this.perSegSize), this.sf), this.rowMeta, this.sf).build();
                }
                this.setsOrderBy = new StoresGroupBy(this.merge(stores), this.sf);
            }
        }
        this.prepare = true;
    }

    @Override
    public SetsOrderBy storesOrderBy(Store[] stores) {
        return new StoresGroupBy(stores, this.sf);
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNest;
        if (!this.prepare) {
            this.init();
        }
        if (hasNest = this.setsOrderBy.hasNext()) {
            this.curRow = this.setsOrderBy.next();
        }
        return hasNest;
    }

    @Override
    public void close() throws SQLException {
        this.setsOrderBy.close();
        this.storeQueue.clear();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.curRow[columnIndex], type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        int columnIndex = (Integer)this.colMetaNameIndexMap.get(columnName.toLowerCase());
        return this.get(columnIndex - 1, type);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.prepare) {
            this.init();
        }
        if (this.sf.getOrderByInfo() != null && this.sf.getOrderByInfo().isResetSelect() || this.oracleSeriesSegMerge) {
            return this.md;
        }
        return this.executionLazyResultSet.getResultSet().getMetaData();
    }
}

