/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine.orderby;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.orderby.ReduceOrderByColumnResultSetMetaData;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.mergeengine.resultset.AbstractMergeSet;
import kd.bos.xdb.mergeengine.resultset.IteratorQueryDataSet;

public class OrderByMergeSet
extends AbstractMergeSet {
    private IteratorQueryDataSet iteratorQueryDataSet;
    private boolean prepare = false;
    private ResultSetMetaData md;

    public OrderByMergeSet(IteratorQueryDataSet iteratorQueryDataSet, SelectFeature sf) throws SQLException {
        this.iteratorQueryDataSet = iteratorQueryDataSet;
        this.sf = sf;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.prepare) {
            this.init();
        }
        return this.iteratorQueryDataSet.next();
    }

    private void init() throws SQLException {
        if (this.sf.getOrderByInfo().isResetSelect()) {
            this.md = new ReduceOrderByColumnResultSetMetaData(this.iteratorQueryDataSet.getMetaData(), this.sf.getOrderByInfo().getOriginalSelectColumnCount());
        }
        this.flushMetaNameIndex(this.iteratorQueryDataSet.getExecutionLazyResultSet().getResultSet());
        this.sf.getOrderByInfo().flushOrderByItemIndex(this.colMetaNameIndexMap, this.colExprNameIndexMap);
        this.iteratorQueryDataSet.build();
        this.iteratorQueryDataSet.orderBy(this.sf.getOrderByInfo());
        this.prepare = true;
    }

    @Override
    public void close() throws SQLException {
        if (this.iteratorQueryDataSet != null) {
            this.iteratorQueryDataSet.close();
        }
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.iteratorQueryDataSet.getRow().get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        int columnIndex = (Integer)this.colMetaNameIndexMap.get(columnName.toLowerCase());
        return this.get(columnIndex - 1, type);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (!this.prepare) {
            this.init();
        }
        if (this.sf.getOrderByInfo().isResetSelect()) {
            return this.md;
        }
        return this.iteratorQueryDataSet.getMetaData();
    }
}

